/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui.resultsview;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.n4js.tester.ui.TesterUiActivator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;

class TestViewLayoutHelper {
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_AUTOMATIC = 2;
    static final String[] LABELS = new String[]{"Vertical", "Horizontal", "Automatic"};
    static final String[] ICON_IDS = new String[]{"th_vertical.gif", "th_horizontal.gif", "th_automatic.gif"};
    private final ToggleOrientationAction[] actions;
    final IMenuManager orientationMenu;
    private final SashForm sash;
    private int orientation = 2;

    TestViewLayoutHelper(SashForm sash) {
        this.sash = sash;
        this.actions = new ToggleOrientationAction[LABELS.length];
        this.orientationMenu = new MenuManager("Layout");
        int i = 0;
        while (i < LABELS.length) {
            this.actions[i] = new ToggleOrientationAction(i);
            this.orientationMenu.add((IAction)this.actions[i]);
            ++i;
        }
    }

    int getOrientation() {
        return this.orientation;
    }

    void setOrientation(int orientation) {
        this.orientation = orientation;
        if (this.sash == null || this.sash.isDisposed()) {
            return;
        }
        this.updateSashLayout();
        this.udpateActions();
        this.sash.getParent().layout();
    }

    void updateSashLayout() {
        int sashLayout = 512;
        switch (this.orientation) {
            case 0: {
                break;
            }
            case 1: {
                sashLayout = 256;
                break;
            }
            default: {
                Point size = this.sash.getParent().getSize();
                int n = sashLayout = size.x > size.y ? 256 : 512;
            }
        }
        if (sashLayout != this.sash.getOrientation()) {
            this.sash.setOrientation(sashLayout);
        }
    }

    public void udpateActions() {
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i].setChecked(this.orientation == this.actions[i].actionOrientation);
            ++i;
        }
    }

    private class ToggleOrientationAction
    extends Action {
        private final int actionOrientation;

        ToggleOrientationAction(int orientation) {
            super(LABELS[orientation], 8);
            this.setImageDescriptor(TesterUiActivator.getImageDescriptor(ICON_IDS[orientation]));
            this.actionOrientation = orientation;
        }

        public void run() {
            if (this.isChecked()) {
                TestViewLayoutHelper.this.setOrientation(this.actionOrientation);
            }
        }
    }
}

