/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.n4js.ui.organize.imports.BreakException;
import org.eclipse.n4js.ui.organize.imports.DocumentImportsOrganizer;
import org.eclipse.n4js.ui.organize.imports.Interaction;
import org.eclipse.n4js.utils.languages.N4LanguageUtils;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class OrganizeImportsService {
    private static final Logger LOGGER = Logger.getLogger(OrganizeImportsService.class);

    public static void organizeImportsInFile(IFile currentFile, Interaction interaction, SubMonitor subMon) throws CoreException {
        SubMonitor subSubMon = subMon.split(1, 0);
        subSubMon.setTaskName(currentFile.getName());
        DocumentImportsOrganizer imortsOrganizer = OrganizeImportsService.getOrganizeImports(currentFile);
        imortsOrganizer.organizeFile(currentFile, interaction, (IProgressMonitor)subSubMon);
    }

    public static void organizeImportsInFile(IFile currentFile, Interaction interaction, IProgressMonitor mon) throws CoreException {
        DocumentImportsOrganizer imortsOrganizer = OrganizeImportsService.getOrganizeImports(currentFile);
        imortsOrganizer.organizeFile(currentFile, interaction, mon);
    }

    public static void organizeImportsInEditor(XtextEditor editor, Interaction interaction) {
        try {
            IResource resource = editor.getResource();
            DocumentImportsOrganizer imortsOrganizer = OrganizeImportsService.getOrganizeImports(resource);
            imortsOrganizer.organizeDocument(editor.getDocument(), interaction);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof BreakException) {
                LOGGER.debug((Object)"user canceled");
            }
            LOGGER.warn((Object)"Unrecognized RT-exception", (Throwable)re);
        }
    }

    private static DocumentImportsOrganizer getOrganizeImports(IFile ifile) {
        return (DocumentImportsOrganizer)N4LanguageUtils.getServiceForContext((IFile)ifile, DocumentImportsOrganizer.class).get();
    }

    private static DocumentImportsOrganizer getOrganizeImports(IResource iresource) {
        return (DocumentImportsOrganizer)N4LanguageUtils.getServiceForContext((IResource)iresource, DocumentImportsOrganizer.class).get();
    }
}

