/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.editor.AntEditorCompletionProcessor;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.xml.sax.Attributes;

public class AntImportNode
extends AntTaskNode {
    private String fFile = null;

    public AntImportNode(Task task, Attributes attributes) {
        super(task);
        this.fFile = attributes.getValue("file");
    }

    public String getFile() {
        return this.fFile;
    }

    @Override
    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antImport");
    }

    @Override
    public String getLabel() {
        if (this.fLabel == null) {
            StringBuffer label = new StringBuffer(this.getTask().getTaskName());
            label.append(' ');
            label.append(this.fFile);
            if (this.isExternal()) {
                this.appendEntityName(label);
            }
            this.fLabel = label.toString();
        }
        return this.fLabel;
    }

    @Override
    public boolean configure(boolean validateFully) {
        if (this.fConfigured) {
            return false;
        }
        try {
            this.getTask().maybeConfigure();
            this.getTask().execute();
            this.fConfigured = true;
            return true;
        }
        catch (BuildException be) {
            this.handleBuildException(be, "problem_imports");
        }
        catch (AntSecurityException antSecurityException) {
            this.handleBuildException(new BuildException(AntModelMessages.AntImportNode_0), "problem_security");
        }
        return false;
    }

    @Override
    public IFile getIFile() {
        IFile file;
        if (this.isExternal()) {
            file = AntUtil.getFileForLocation(this.getFilePath(), null);
        } else {
            String path = this.getFile();
            file = AntUtil.getFileForLocation(path, this.getAntModel().getEditedFile().getParentFile());
        }
        return file;
    }

    @Override
    public String getReferencedElement(int offset) {
        String attributeString;
        String textToSearch;
        if (this.fFile != null && (textToSearch = this.getAntModel().getText(this.getOffset(), offset - this.getOffset())) != null && textToSearch.length() != 0 && "file".equals(attributeString = AntEditorCompletionProcessor.getAttributeStringFromDocumentStringToPrefix(textToSearch))) {
            return this.fFile;
        }
        return null;
    }
}

