/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.Set;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.ast.StatementWithBody;
import org.eclipse.internal.xpand2.pr.ProtectedRegion;
import org.eclipse.internal.xpand2.pr.ProtectedRegionSyntaxException;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectStatement
extends StatementWithBody {
    private final Expression commentStart;
    private final Expression commentEnd;
    private final Expression id;
    private final boolean disable;

    public ProtectStatement(Expression commentStart, Expression commentEnd, Statement[] body, Expression id, boolean disable) {
        super(body);
        this.commentStart = commentStart;
        this.commentEnd = commentEnd;
        this.id = id;
        this.disable = disable;
    }

    public Expression getCommentEnd() {
        return this.commentEnd;
    }

    public Expression getCommentStart() {
        return this.commentStart;
    }

    public Expression getId() {
        return this.id;
    }

    public boolean getDisable() {
        return this.disable;
    }

    @Override
    public void analyzeInternal(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        this.getCommentStart().analyze((ExecutionContext)ctx, issues);
        this.getCommentEnd().analyze((ExecutionContext)ctx, issues);
        this.getId().analyze((ExecutionContext)ctx, issues);
        Statement[] statementArray = this.body;
        int n = this.body.length;
        int n2 = 0;
        while (n2 < n) {
            Statement element = statementArray[n2];
            element.analyze(ctx, issues);
            ++n2;
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        String cStart = this.nullSafe(this.getCommentStart().evaluate((ExecutionContext)ctx));
        if (cStart == null) {
            throw new EvaluationException("NullEvaluation!", (SyntaxElement)this.getCommentStart(), (ExecutionContext)ctx);
        }
        String cEnd = this.nullSafe(this.getCommentEnd().evaluate((ExecutionContext)ctx));
        if (cEnd == null) {
            throw new EvaluationException("NullEvaluation!", (SyntaxElement)this.getCommentEnd(), (ExecutionContext)ctx);
        }
        String id = this.nullSafe(this.getId().evaluate((ExecutionContext)ctx));
        if (id == null) {
            throw new EvaluationException("NullEvaluation!", (SyntaxElement)this.getId(), (ExecutionContext)ctx);
        }
        ProtectedRegion region = null;
        if (ctx.getProtectedRegionResolver() == null) {
            throw new EvaluationException("No protected region resolver configured!", (SyntaxElement)this, (ExecutionContext)ctx);
        }
        region = ctx.getProtectedRegionResolver().getProtectedRegion(id.toString());
        if (region == null) {
            region = ctx.getProtectedRegionResolver().createProtectedRegion(id, this.disable);
            ctx.getOutput().write(region.getStartString(cStart, cEnd));
            Statement[] statementArray = this.body;
            int n = this.body.length;
            int n2 = 0;
            while (n2 < n) {
                Statement element = statementArray[n2];
                element.evaluate(ctx);
                ++n2;
            }
            ctx.getOutput().write(region.getEndString(cStart, cEnd));
        } else {
            ctx.getOutput().write(region.getStartString(cStart, cEnd));
            try {
                ctx.getOutput().write(region.getBody(cStart, cEnd));
            }
            catch (ProtectedRegionSyntaxException e) {
                throw new EvaluationException(e.getMessage(), (SyntaxElement)this.getId(), (ExecutionContext)ctx);
            }
            ctx.getOutput().write(region.getEndString(cStart, cEnd));
        }
    }

    private String nullSafe(Object string) {
        return string != null ? string.toString() : "";
    }
}

