/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.internal;

import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.n4js.ts.types.NameAndAccess;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.utils.TransformedIterator2;

public class MemberByNameAndAccessMap
extends AbstractMap<NameAndAccess, TMember> {
    private final List<? extends TMember> members;

    public MemberByNameAndAccessMap(List<? extends TMember> members) {
        this.members = members;
    }

    @Override
    public Set<Map.Entry<NameAndAccess, TMember>> entrySet() {
        return new AbstractSet<Map.Entry<NameAndAccess, TMember>>(){

            @Override
            public Iterator<Map.Entry<NameAndAccess, TMember>> iterator() {
                return Iterators.unmodifiableIterator((Iterator)new TransformedIterator2<TMember, Map.Entry<NameAndAccess, TMember>>(MemberByNameAndAccessMap.this.members.iterator()){

                    protected Map.Entry<NameAndAccess, TMember> transform(TMember input) {
                        NameAndAccess[] nameAndAccess = NameAndAccess.of(input);
                        if (nameAndAccess.length > 1) {
                            this.setAdditionalElement(new AbstractMap.SimpleImmutableEntry<NameAndAccess, TMember>(nameAndAccess[1], input));
                        }
                        return new AbstractMap.SimpleImmutableEntry<NameAndAccess, TMember>(nameAndAccess[0], input);
                    }
                });
            }

            @Override
            public int size() {
                return MemberByNameAndAccessMap.this.members.size();
            }
        };
    }

    @Override
    public int size() {
        return this.members.size();
    }

    @Override
    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public TMember get(Object key) {
        if (key instanceof NameAndAccess) {
            int i = 0;
            int size = this.members.size();
            while (i < size) {
                TMember result = this.members.get(i);
                NameAndAccess nameAndAccess = (NameAndAccess)key;
                if (nameAndAccess.getName().equals(result.getName()) && nameAndAccess.isStaticAccess() == result.isStatic() && (nameAndAccess.isWriteAccess() && result.isWriteable() || !nameAndAccess.isWriteAccess() && result.isReadable())) {
                    return result;
                }
                ++i;
            }
        }
        return null;
    }
}

