/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.PluginPreferenceInitializer;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.preferences.DoublePreferencesPreferencePage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CommittingPreferencePage
extends DoublePreferencesPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor useStagingView;
    private BooleanFieldEditor autoStage;
    private Button warnCheckbox;
    private Group buildProblemsGroup;
    private ComboFieldEditor warnCombo;
    private Button blockCheckbox;
    private ComboFieldEditor blockCombo;
    private Group generalGroup;

    public CommittingPreferencePage() {
        super(1);
        this.setTitle(UIText.CommittingPreferencePage_title);
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    @Override
    protected IPreferenceStore doGetSecondaryPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, org.eclipse.egit.core.Activator.getPluginId());
    }

    protected void createFieldEditors() {
        Composite main = this.getFieldEditorParent();
        this.generalGroup = new Group(main, 16);
        this.generalGroup.setText(UIText.CommittingPreferencePage_general);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.generalGroup);
        this.useStagingView = new BooleanFieldEditor("always_use_staging_view", UIText.CommittingPreferencePage_AlwaysUseStagingView, (Composite)this.generalGroup);
        this.addField((FieldEditor)this.useStagingView);
        this.autoStage = new BooleanFieldEditor("auto_stage_on_commit", UIText.CommittingPreferencePage_AutoStageOnCommit, (Composite)this.generalGroup);
        GridDataFactory.fillDefaults().indent(UIUtils.getControlIndent(), 0).applyTo(this.autoStage.getDescriptionControl((Composite)this.generalGroup));
        this.addField((FieldEditor)this.autoStage);
        this.autoStage.setEnabled(this.getPreferenceStore().getBoolean("always_use_staging_view"), (Composite)this.generalGroup);
        BooleanFieldEditor includeUntracked = new BooleanFieldEditor("commit_dialog_include_untracked", UIText.CommittingPreferencePage_includeUntrackedFiles, (Composite)this.generalGroup);
        includeUntracked.getDescriptionControl((Composite)this.generalGroup).setToolTipText(UIText.CommittingPreferencePage_includeUntrackedFilesTooltip);
        this.addField((FieldEditor)includeUntracked);
        BooleanFieldEditor autoStageDeletion = new BooleanFieldEditor("core_auto_stage_deletion", UIText.CommittingPreferencePage_autoStageDeletion, (Composite)this.generalGroup){

            public IPreferenceStore getPreferenceStore() {
                return CommittingPreferencePage.this.getSecondaryPreferenceStore();
            }
        };
        this.addField((FieldEditor)autoStageDeletion);
        BooleanFieldEditor autoStageMoves = new BooleanFieldEditor("core_auto_stage_moves", UIText.CommittingPreferencePage_autoStageMoves, (Composite)this.generalGroup){

            public IPreferenceStore getPreferenceStore() {
                return CommittingPreferencePage.this.getSecondaryPreferenceStore();
            }
        };
        this.addField((FieldEditor)autoStageMoves);
        IntegerFieldEditor historySize = new IntegerFieldEditor("commit_dialog_history_size", UIText.CommittingPreferencePage_commitMessageHistory, (Composite)this.generalGroup);
        this.addField((FieldEditor)historySize);
        this.updateMargins(this.generalGroup);
        Group formattingGroup = new Group(main, 16);
        formattingGroup.setText(UIText.CommittingPreferencePage_formatting);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)formattingGroup);
        BooleanFieldEditor hardWrap = new BooleanFieldEditor("commit_dialog_hard_wrap_message", UIText.CommittingPreferencePage_hardWrapMessage, (Composite)formattingGroup);
        hardWrap.getDescriptionControl((Composite)formattingGroup).setToolTipText(UIText.CommittingPreferencePage_hardWrapMessageTooltip);
        this.addField((FieldEditor)hardWrap);
        BooleanFieldEditor secondLineCheck = new BooleanFieldEditor("commit_dialog_warn_about_message_second_line", UIText.CommittingPreferencePage_warnAboutCommitMessageSecondLine, (Composite)formattingGroup);
        this.addField((FieldEditor)secondLineCheck);
        this.updateMargins(formattingGroup);
        Group footersGroup = new Group(main, 16);
        footersGroup.setText(UIText.CommittingPreferencePage_footers);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)footersGroup);
        BooleanFieldEditor signedOffBy = new BooleanFieldEditor("commit_dialog_signed_off_by", UIText.CommittingPreferencePage_signedOffBy, (Composite)footersGroup);
        signedOffBy.getDescriptionControl((Composite)footersGroup).setToolTipText(UIText.CommittingPreferencePage_signedOffByTooltip);
        this.addField((FieldEditor)signedOffBy);
        this.updateMargins(footersGroup);
        this.buildProblemsGroup = this.createGroup(main, 1);
        this.buildProblemsGroup.setText(UIText.CommittingPreferencePage_WarnBeforeCommittingTitle);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.buildProblemsGroup);
        this.warnCheckbox = this.createCheckBox((Composite)this.buildProblemsGroup, UIText.CommittingPreferencePage_CheckBeforeCommitting);
        ((GridData)this.warnCheckbox.getLayoutData()).horizontalSpan = 3;
        this.warnCheckbox.setSelection(this.doGetPreferenceStore().getBoolean("checkBeforeCommitting"));
        this.warnCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommittingPreferencePage.this.handleWarnCheckboxSelection(CommittingPreferencePage.this.warnCheckbox.getSelection());
            }
        });
        this.warnCombo = new ComboFieldEditor("warnBeforeCommitting", UIText.CommittingPreferencePage_WarnBeforeCommitting, (String[][])new String[][]{{UIText.CommittingPreferencePage_WarnBlock_Errors, PluginPreferenceInitializer.COMMITTING_PREFERENCE_PAGE_WARN_BLOCK_ERRORS}, {UIText.CommittingPreferencePage_WarnBlock_WarningsAndErrors, PluginPreferenceInitializer.COMMITTING_PREFERENCE_PAGE_WARN_BLOCK_WARNINGS_AND_ERRORS}}, (Composite)this.buildProblemsGroup);
        this.addField((FieldEditor)this.warnCombo);
        this.blockCheckbox = this.createCheckBox((Composite)this.buildProblemsGroup, UIText.CommittingPreferencePage_BlockCommit);
        ((GridData)this.blockCheckbox.getLayoutData()).horizontalSpan = 3;
        this.blockCheckbox.setSelection(this.doGetPreferenceStore().getBoolean("blockCommit"));
        this.blockCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommittingPreferencePage.this.handleBlockCheckboxSelection(CommittingPreferencePage.this.blockCheckbox.getSelection());
            }
        });
        this.blockCombo = new ComboFieldEditor("blockCommitCombo", UIText.CommittingPreferencePage_BlockCommitCombo, (String[][])new String[][]{{UIText.CommittingPreferencePage_WarnBlock_Errors, PluginPreferenceInitializer.COMMITTING_PREFERENCE_PAGE_WARN_BLOCK_ERRORS}, {UIText.CommittingPreferencePage_WarnBlock_WarningsAndErrors, PluginPreferenceInitializer.COMMITTING_PREFERENCE_PAGE_WARN_BLOCK_WARNINGS_AND_ERRORS}}, (Composite)this.buildProblemsGroup);
        this.addField((FieldEditor)this.blockCombo);
        this.handleWarnCheckboxSelection(this.warnCheckbox.getSelection());
        this.handleBlockCheckboxSelection(this.blockCheckbox.getSelection());
        this.updateMargins(this.buildProblemsGroup);
    }

    protected void initialize() {
        super.initialize();
        this.useStagingView.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("field_editor_value".equals(event.getProperty())) {
                    CommittingPreferencePage.this.autoStage.setEnabled(((Boolean)event.getNewValue()).booleanValue(), (Composite)CommittingPreferencePage.this.generalGroup);
                }
            }
        });
    }

    protected void performDefaults() {
        super.performDefaults();
        this.autoStage.setEnabled(this.getPreferenceStore().getDefaultBoolean("always_use_staging_view"), (Composite)this.generalGroup);
    }

    private void updateMargins(Group group) {
        GridLayout layout = (GridLayout)group.getLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    private void handleBlockCheckboxSelection(boolean selection) {
        this.blockCombo.setEnabled(selection, (Composite)this.buildProblemsGroup);
        if (selection) {
            this.warnCheckbox.setSelection(true);
            this.warnCheckbox.setEnabled(false);
        } else {
            this.warnCheckbox.setEnabled(true);
        }
    }

    private void handleWarnCheckboxSelection(boolean selection) {
        this.warnCombo.setEnabled(selection, (Composite)this.buildProblemsGroup);
        this.blockCheckbox.setEnabled(selection);
        this.blockCombo.setEnabled(selection, (Composite)this.buildProblemsGroup);
    }

    @Override
    public boolean performOk() {
        this.getPreferenceStore().setValue("checkBeforeCommitting", this.warnCheckbox.getSelection());
        this.getPreferenceStore().setValue("blockCommit", this.blockCheckbox.getSelection());
        return super.performOk();
    }

    private Group createGroup(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 0x1000008;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }
}

