/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ParallelBuildManager {
    private final ExecutorService pool = Executors.newFixedThreadPool(3);
    private final Collection<? extends ParallelJob<?>> jobs;
    private final Map<Object, ParallelJob<?>> jobMap = new HashMap();
    private final Map<Object, Set<Object>> dependencyMap = new HashMap<Object, Set<Object>>();
    private final Map<Object, Set<Object>> waitingProjectsMap = new HashMap<Object, Set<Object>>();
    private final Set<ParallelJob<?>> startJobs = new HashSet();
    private final Set<Object> currentJobs = new HashSet<Object>();

    ParallelBuildManager(Collection<? extends ParallelJob<?>> jobs) {
        this.jobs = jobs;
    }

    private void init() {
        Object jobID;
        for (ParallelJob<?> job : this.jobs) {
            job.pbm = this;
            jobID = job.getID();
            this.jobMap.put(jobID, job);
        }
        for (ParallelJob<?> job : this.jobs) {
            jobID = job.getID();
            ArrayList<Object> dependencies = new ArrayList<Object>(job.getDependencyIDs());
            dependencies.retainAll(this.jobMap.keySet());
            if (dependencies.isEmpty()) {
                this.startJobs.add(job);
                continue;
            }
            this.dependencyMap.put(jobID, new HashSet(dependencies));
            for (Object e : dependencies) {
                this.waitingProjectsMap.computeIfAbsent(e, ign -> new HashSet()).add(jobID);
            }
        }
    }

    private synchronized Set<Object> setFinishedGetNexts(Object jobID) {
        HashSet<Object> newReadyJobIDs = new HashSet<Object>();
        if (this.waitingProjectsMap.containsKey(jobID)) {
            Set<Object> waitingJobIDs = this.waitingProjectsMap.get(jobID);
            for (Object waitingJobID : waitingJobIDs) {
                if (!this.dependencyMap.containsKey(waitingJobID)) continue;
                Set<Object> dependenciesOfJobID = this.dependencyMap.get(waitingJobID);
                dependenciesOfJobID.remove(jobID);
                if (!dependenciesOfJobID.isEmpty()) continue;
                newReadyJobIDs.add(waitingJobID);
                this.dependencyMap.remove(waitingJobID);
            }
        }
        return newReadyJobIDs;
    }

    public void run() {
        this.init();
        this.currentJobs.addAll(this.startJobs);
        for (ParallelJob<?> startJob : this.startJobs) {
            this.pool.execute(startJob);
        }
        try {
            this.pool.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNext(ParallelJob<?> job) {
        Object jobID = job.getID();
        this.currentJobs.remove(job);
        Set<Object> newReadyJobIDs = this.setFinishedGetNexts(jobID);
        if (this.currentJobs.isEmpty() && newReadyJobIDs.isEmpty() && !this.dependencyMap.isEmpty()) {
            this.pool.shutdown();
            System.err.println("Did not finish all jobs");
        }
        for (Object newReadyJobID : newReadyJobIDs) {
            ParallelJob<?> readyJob = this.jobMap.get(newReadyJobID);
            this.currentJobs.add(readyJob);
            this.pool.execute(readyJob);
        }
        ExecutorService executorService = this.pool;
        synchronized (executorService) {
            this.pool.notifyAll();
            if (this.dependencyMap.isEmpty()) {
                this.pool.shutdown();
            }
        }
    }

    static abstract class ParallelJob<T>
    implements Runnable {
        protected ParallelBuildManager pbm;

        ParallelJob() {
        }

        @Override
        public void run() {
            this.runJob();
            this.pbm.scheduleNext(this);
        }

        public abstract void runJob();

        public abstract T getID();

        public abstract Collection<T> getDependencyIDs();
    }
}

