/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.scoping;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4idl.scoping.N4IDLVersionableFilter;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.scoping.TopLevelElementsCollector;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.xtext.resource.IEObjectDescription;

public class N4IDLAwareTopLevelElementsCollector
extends TopLevelElementsCollector {
    private static final Logger LOGGER = Logger.getLogger(N4IDLAwareTopLevelElementsCollector.class);
    @Inject
    private IN4JSCore n4jsCore;

    @Override
    public Iterable<IEObjectDescription> getTopLevelElements(TModule module, Resource contextResource) {
        Optional<? extends IN4JSProject> project = this.n4jsCore.findProject(contextResource.getURI());
        Iterable<IEObjectDescription> allTopLevelElements = super.getTopLevelElements(module, contextResource);
        if (!project.isPresent()) {
            LOGGER.warn((Object)String.format("Failed to determine project of resource %s.", contextResource.getURI()));
            return allTopLevelElements;
        }
        if (module.eResource() == null) {
            LOGGER.warn((Object)String.format("Failed to determine resource of TModule %s.", module));
            return allTopLevelElements;
        }
        Optional<? extends IN4JSProject> moduleProject = this.n4jsCore.findProject(module.eResource().getURI());
        if (!moduleProject.isPresent()) {
            LOGGER.warn((Object)String.format("Failed to determine project of TModule %s.", module.getQualifiedName()));
            return allTopLevelElements;
        }
        IN4JSProject contextN4JSProject = (IN4JSProject)project.get();
        IN4JSProject versionedN4JSProject = (IN4JSProject)moduleProject.get();
        int contextVersion = this.getProjectContextVersion(versionedN4JSProject, contextN4JSProject);
        if (contextVersion < 1) {
            return allTopLevelElements;
        }
        N4IDLVersionableFilter versionableFilter = new N4IDLVersionableFilter(contextVersion);
        return versionableFilter.filterElements(allTopLevelElements);
    }

    private int getProjectContextVersion(IN4JSProject versionedProject, IN4JSProject contextProject) {
        return Integer.MAX_VALUE;
    }
}

