/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.nls;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.nls.MessageConsumer;
import org.eclipse.e4.core.services.nls.MessageFunction;
import org.eclipse.e4.core.services.nls.MessageSupplier;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

public class BaseMessageRegistry<M> {
    private M messages;
    private final Map<MessageConsumer, MessageSupplier> bindings = new HashMap<MessageConsumer, MessageSupplier>();
    private Logger registryLogger;
    private Logger consumerLogger;
    private Logger supplierLogger;

    @Inject
    @Optional
    void setLoggerFactory(LoggerFactory factory) {
        if (factory != null) {
            this.registryLogger = factory.getLogger(BaseMessageRegistry.class);
            this.consumerLogger = factory.getLogger(MessageConsumerImplementation.class);
            this.supplierLogger = factory.getLogger(MessageSupplierImplementation.class);
        } else {
            this.registryLogger = null;
            this.consumerLogger = null;
            this.supplierLogger = null;
        }
    }

    public void register(MessageConsumer consumer, MessageFunction<M> function) {
        this.register(consumer, () -> function.apply(this.messages));
    }

    public void register(MessageConsumer consumer, MessageSupplier supplier) {
        consumer.accept(supplier.get());
        this.bindings.put(consumer, supplier);
    }

    public void register(Object control, String method, String messageKey) {
        MessageConsumer consumer = this.createConsumer(control, method);
        MessageSupplier supplier = this.createSupplier(messageKey);
        if (consumer != null && supplier != null) {
            this.register(consumer, supplier);
        }
    }

    public void registerProperty(Object control, String property, String messageKey) {
        MessageConsumer consumer = this.createConsumer(control, "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1));
        MessageSupplier supplier = this.createSupplier(messageKey);
        if (consumer != null && supplier != null) {
            this.register(consumer, supplier);
        }
    }

    public void updateMessages(M messages) {
        this.messages = messages;
        for (Map.Entry<MessageConsumer, MessageSupplier> entry : this.bindings.entrySet()) {
            entry.getKey().accept(entry.getValue().get());
        }
    }

    protected MessageConsumer createConsumer(Object control, String method) {
        block5: {
            try {
                Method m = control.getClass().getMethod(method, String.class);
                if (m != null) {
                    return new MessageConsumerImplementation(m, control);
                }
            }
            catch (NoSuchMethodException e) {
                Logger log = this.registryLogger;
                if (log != null) {
                    log.warn("The method '{}' does not exist. Binding is not created!", (Object)e.getMessage());
                }
            }
            catch (SecurityException e) {
                Logger log = this.registryLogger;
                if (log == null) break block5;
                log.warn("Error on accessing method '{}' on class '{}' with error message '{}'. Binding is not created!", new Object[]{method, control.getClass(), e.getMessage()});
            }
        }
        return null;
    }

    protected MessageSupplier createSupplier(String messageKey) {
        block5: {
            try {
                Field f = this.messages.getClass().getField(messageKey);
                if (f != null) {
                    return new MessageSupplierImplementation(f);
                }
            }
            catch (NoSuchFieldException e) {
                Logger log = this.registryLogger;
                if (log != null) {
                    log.warn("The class '{}' does not contain a field with name '{}'. Binding is not created!", (Object)this.messages.getClass().getName(), (Object)e.getMessage());
                }
            }
            catch (SecurityException e) {
                Logger log = this.registryLogger;
                if (log == null) break block5;
                log.warn("Error on accessing field '{}' on class '{}' with error message '{}'. Binding is not created!", new Object[]{messageKey, this.messages.getClass(), e.getMessage()});
            }
        }
        return null;
    }

    @PreDestroy
    void unregister() {
        this.bindings.clear();
    }

    private final class MessageConsumerImplementation
    implements MessageConsumer {
        private final Method m;
        private final Object control;

        private MessageConsumerImplementation(Method m, Object control) {
            this.m = m;
            this.control = control;
        }

        @Override
        public void accept(String value) {
            block4: {
                try {
                    if (System.getSecurityManager() == null) {
                        this.m.setAccessible(true);
                        this.m.invoke(this.control, value);
                    } else {
                        AccessController.doPrivileged(() -> {
                            block2: {
                                this.m.setAccessible(true);
                                try {
                                    this.m.invoke(this.control, value);
                                }
                                catch (Exception e) {
                                    BaseMessageRegistry.this.bindings.remove(this);
                                    Logger log = BaseMessageRegistry.this.consumerLogger;
                                    if (log == null) break block2;
                                    log.info("Error on invoke '{}' on '{}' with error message '{}'. Binding is removed.", new Object[]{this.m.getName(), this.control.getClass(), e.getMessage()});
                                }
                            }
                            return null;
                        });
                    }
                }
                catch (Exception e) {
                    BaseMessageRegistry.this.bindings.remove(this);
                    Logger log = BaseMessageRegistry.this.consumerLogger;
                    if (log == null) break block4;
                    log.info("Error on invoke '{}' on '{}' with error message '{}'. Binding is removed.", new Object[]{this.m.getName(), this.control.getClass(), e.getMessage()});
                }
            }
        }
    }

    private final class MessageSupplierImplementation
    implements MessageSupplier {
        private final Field f;

        private MessageSupplierImplementation(Field f) {
            this.f = f;
        }

        @Override
        public String get() {
            String message;
            block2: {
                message = null;
                try {
                    message = (String)this.f.get(BaseMessageRegistry.this.messages);
                }
                catch (Exception e) {
                    Iterator iterator = BaseMessageRegistry.this.bindings.entrySet().iterator();
                    iterator.forEachRemaining(entry -> {
                        if (entry.getValue() == this) {
                            iterator.remove();
                        }
                    });
                    Logger log = BaseMessageRegistry.this.supplierLogger;
                    if (log == null) break block2;
                    log.info("Error on invoke '{}' on '{}' with error message '{}'. Binding is removed.", new Object[]{this.f.getName(), BaseMessageRegistry.this.messages.getClass(), e.getMessage()});
                }
            }
            return message;
        }
    }
}

