/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.eclipse.xtext.resource.impl.ProjectDescription;

public class XTopologicalSorter {
    public List<ProjectDescription> sortByDependencies(Iterable<ProjectDescription> descriptions, Consumer<ProjectDescription> cyclicAcceptor) {
        TreeMap<String, Entry> name2entry = new TreeMap<String, Entry>();
        LinkedHashSet<ProjectDescription> result = new LinkedHashSet<ProjectDescription>();
        for (ProjectDescription pd : descriptions) {
            name2entry.put(pd.getName(), new Entry(pd));
        }
        for (Entry entry : name2entry.values()) {
            this.visit(cyclicAcceptor, name2entry, entry, result);
        }
        return new ArrayList<ProjectDescription>(result);
    }

    protected boolean visit(Consumer<ProjectDescription> cyclicAcceptor, SortedMap<String, Entry> name2entry, Entry entry, LinkedHashSet<ProjectDescription> result) {
        if (!result.contains(entry.description) && !entry.cyclic) {
            if (entry.marked) {
                this.markCyclic(cyclicAcceptor, entry);
                return false;
            }
            entry.marked = true;
            ArrayList dependencies = new ArrayList(entry.description.getDependencies());
            Collections.sort(dependencies);
            for (String depName : dependencies) {
                Entry depEntry = (Entry)name2entry.get(depName);
                if (depEntry == null || this.visit(cyclicAcceptor, name2entry, depEntry, result)) continue;
                this.markCyclic(cyclicAcceptor, entry);
                return false;
            }
            entry.marked = false;
            result.add(entry.description);
        }
        return true;
    }

    protected void markCyclic(Consumer<ProjectDescription> cyclicAcceptor, Entry entry) {
        if (!entry.cyclic) {
            entry.cyclic = true;
            cyclicAcceptor.accept(entry.description);
        }
    }

    protected static class Entry {
        private final ProjectDescription description;
        private boolean marked;
        private boolean cyclic;

        public String toString() {
            return this.description.getName();
        }

        public Entry(ProjectDescription description) {
            this.description = description;
        }
    }
}

