/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.URI;

@Singleton
public class MultiCleartriggerCache {
    public static final String CACHE_KEY_PROJECT_DESCRIPTIONS = "PROJECT_DESCRIPTIONS";
    public static final String CACHE_KEY_SORTED_DEPENDENCIES = "SORTED_DEPENDENCIES";
    public static final String CACHE_KEY_API_IMPL_MAPPING = "API_IMPL_MAPPING";
    private static final URI GLOBAL = URI.createURI((String)"n4js://global");
    private final Map<String, Map<URI, Object>> entryCache = new HashMap<String, Map<URI, Object>>();
    private final Map<String, Multimap<URI, URI>> triggerCache = new HashMap<String, Multimap<URI, URI>>();

    public <Entry> Entry get(Supplier<Entry> supplier, String key) {
        return this.get(supplier, key, GLOBAL);
    }

    public <Entry> Entry get(Supplier<Entry> supplier, String key, URI reference) {
        Object entry;
        Map<URI, Object> entryMap;
        if (!this.entryCache.containsKey(key)) {
            this.entryCache.put(key, new HashMap());
            if (supplier instanceof CleartriggerSupplier) {
                this.triggerCache.put(key, (Multimap<URI, URI>)HashMultimap.create());
            }
        }
        if (!(entryMap = this.entryCache.get(key)).containsKey(reference) && supplier != null) {
            entry = supplier.get();
            entryMap.put(reference, entry);
            if (this.triggerCache.containsKey(key)) {
                CleartriggerSupplier ratProvider = (CleartriggerSupplier)supplier;
                Multimap<URI, URI> triggerMap = this.triggerCache.get(key);
                for (URI trigger : ratProvider.getCleartriggers()) {
                    if (reference.equals(trigger)) continue;
                    triggerMap.put((Object)trigger, (Object)reference);
                }
                ratProvider.postSupply();
            }
        }
        entry = entryMap.get(reference);
        return (Entry)entry;
    }

    public void clear() {
        this.entryCache.clear();
        this.triggerCache.clear();
    }

    public void clear(String key) {
        Map<URI, Object> map = this.entryCache.get(key);
        Multimap<URI, URI> triggerMap = this.triggerCache.get(key);
        if (map != null) {
            map.clear();
        }
        if (triggerMap != null) {
            triggerMap.clear();
        }
    }

    public void clear(String key, URI trigger) {
        Map<URI, Object> map = this.entryCache.get(key);
        if (map != null) {
            map.remove(trigger);
            Multimap<URI, URI> triggerMap = this.triggerCache.get(key);
            if (triggerMap != null) {
                for (URI otherTrigger : triggerMap.get((Object)trigger)) {
                    map.remove(otherTrigger);
                }
            }
        }
    }

    public static interface CleartriggerSupplier<Entry>
    extends Supplier<Entry> {
        default public Collection<URI> getCleartriggers() {
            return Collections.emptyList();
        }

        default public void postSupply() {
        }
    }
}

