/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyHandler;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyPopup;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.p2.ui.ICopyable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.swt.IFocusService;

public class CopyUtils {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String DELIMITER = "\t";
    private static final String NESTING_INDENT = "  ";
    private static final String CONTROL_ID = "org.eclipse.equinox.p2.ui.CopyControlId";

    public static String getIndentedClipboardText(Object[] elements, IUDetailsLabelProvider labelProvider) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < elements.length) {
            if (i > 0) {
                buffer.append(NEWLINE);
            }
            CopyUtils.appendIndention(buffer, elements[i]);
            buffer.append(labelProvider.getClipboardText(elements[i], DELIMITER));
            ++i;
        }
        return buffer.toString();
    }

    public static void activateCopy(ICopyable copyable, final Control control) {
        IFocusService fs = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        IHandlerService hs = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        new CopyPopup(copyable, control);
        if (fs != null && hs != null) {
            fs.addFocusTracker(control, CONTROL_ID);
            IHandlerActivation handlerActivation = hs.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new CopyHandler(copyable), new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) {
                    return context.getVariable("activeFocusControl") == control ? EvaluationResult.TRUE : EvaluationResult.FALSE;
                }

                public void collectExpressionInfo(ExpressionInfo info) {
                    info.addVariableNameAccess("activeFocusControl");
                }
            });
            control.addDisposeListener(e -> hs.deactivateHandler(handlerActivation));
        }
    }

    private static void appendIndention(StringBuilder buffer, Object element) {
        Object parent;
        while (element instanceof ProvElement && (parent = ((ProvElement)element).getParent(element)) != null) {
            buffer.append(NESTING_INDENT);
            element = parent;
        }
    }
}

