/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.xtext.scoping.ForwardingEObjectDescription;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;

public class ResourceDescriptionWithoutModuleUserData
implements IResourceDescription {
    private final IResourceDescription delegate;

    public ResourceDescriptionWithoutModuleUserData(IResourceDescription delegate) {
        this.delegate = delegate;
    }

    public URI getURI() {
        return this.delegate.getURI();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
        return Iterables.transform((Iterable)this.delegate.getExportedObjects(type, name, ignoreCase), this::wrapIfModule);
    }

    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        return Iterables.transform((Iterable)this.delegate.getExportedObjectsByType(type), this::wrapIfModule);
    }

    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        return Iterables.transform((Iterable)this.delegate.getExportedObjectsByObject(object), this::wrapIfModule);
    }

    public Iterable<IEObjectDescription> getExportedObjects() {
        return Iterables.transform((Iterable)this.delegate.getExportedObjects(), this::wrapIfModule);
    }

    public Iterable<QualifiedName> getImportedNames() {
        return this.delegate.getImportedNames();
    }

    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        return this.delegate.getReferenceDescriptions();
    }

    public IResourceDescription getDelegate() {
        return this.delegate;
    }

    private IEObjectDescription wrapIfModule(IEObjectDescription desc) {
        if (desc.getEClass() == TypesPackage.eINSTANCE.getTModule()) {
            return new EObjectDescriptionWithoutModuleUserData(desc);
        }
        return desc;
    }

    private static final class EObjectDescriptionWithoutModuleUserData
    extends ForwardingEObjectDescription {
        public EObjectDescriptionWithoutModuleUserData(IEObjectDescription delegate) {
            super(delegate);
        }

        public String getUserData(String key) {
            if ("serializedScript".equals(key)) {
                return null;
            }
            return this.delegate().getUserData(key);
        }

        public String[] getUserDataKeys() {
            return this.delegate().getUserDataKeys();
        }
    }
}

