/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.contentassist;

import java.util.Collections;
import java.util.Iterator;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ide.contentassist.antlr.lexer.InternalN4JSLexer;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ui.contentassist.ContentAssistTokenTypeMapper;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.util.Strings;

public class NodeModelTokenSource
implements TokenSource {
    private Iterator<ILeafNode> leafNodes;
    private Token next;
    private final ContentAssistTokenTypeMapper tokenTypeMapper;
    private final Keyword semicolon;
    private final Keyword rightCurlyInBlock;
    private final Keyword rightCurlyInArrowExpression;
    private final int startOffset;
    private final int endOffset;

    NodeModelTokenSource(INode node, ContentAssistTokenTypeMapper tokenTypeMapper, N4JSGrammarAccess grammarAccess) {
        this(node, 0, Integer.MAX_VALUE, tokenTypeMapper, grammarAccess);
    }

    NodeModelTokenSource(INode node, int startOffset, int endOffset, ContentAssistTokenTypeMapper tokenTypeMapper, N4JSGrammarAccess grammarAccess) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.tokenTypeMapper = tokenTypeMapper;
        this.leafNodes = node.getLeafNodes().iterator();
        this.rightCurlyInBlock = grammarAccess.getBlockAccess().getRightCurlyBracketKeyword_2();
        this.rightCurlyInArrowExpression = grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2();
        this.semicolon = grammarAccess.getSemiAccess().getSemicolonKeyword();
    }

    public Token nextToken() {
        if (this.next != null) {
            Token result = this.next;
            this.next = null;
            return result;
        }
        if (!this.leafNodes.hasNext()) {
            return Token.EOF_TOKEN;
        }
        ILeafNode leaf = this.leafNodes.next();
        if (leaf.getTotalOffset() >= this.endOffset) {
            this.leafNodes = Collections.emptyIterator();
            return Token.EOF_TOKEN;
        }
        if (leaf.getTotalEndOffset() <= this.startOffset) {
            return this.nextToken();
        }
        if (leaf.getTotalEndOffset() > this.endOffset) {
            return this.toPrefixToken(leaf);
        }
        SyntaxErrorMessage syntaxErrorMessage = leaf.getSyntaxErrorMessage();
        if (syntaxErrorMessage != null && "InternalSemicolonInjectingParser.ASI".equals(syntaxErrorMessage.getIssueCode())) {
            return this.toASIToken(leaf);
        }
        if (leaf.isHidden()) {
            return this.processHiddenToken(leaf);
        }
        int tokenType = this.tokenTypeMapper.getInternalTokenType(leaf);
        return new CommonToken(tokenType, leaf.getText());
    }

    private Token processHiddenToken(ILeafNode leaf) {
        Token result = this.nextToken();
        if (result == Token.EOF_TOKEN && Strings.countLineBreaks((CharSequence)leaf.getText()) > 0) {
            this.next = result;
            CommonToken hidden = new CommonToken(this.tokenTypeMapper.getInternalTokenType(leaf), leaf.getText());
            hidden.setChannel(99);
            return hidden;
        }
        return result;
    }

    private Token toASIToken(ILeafNode leaf) {
        if (leaf.isHidden()) {
            return this.newSemicolonToken(leaf);
        }
        if (!this.leafNodes.hasNext()) {
            int semicolonTokenType;
            int tokenType = this.tokenTypeMapper.getInternalTokenType(leaf);
            if (tokenType == (semicolonTokenType = this.tokenTypeMapper.getInternalTokenType((EObject)this.semicolon))) {
                return new CommonToken(semicolonTokenType, leaf.getText());
            }
            if (leaf.getTotalEndOffset() == this.endOffset) {
                this.leafNodes = Collections.emptyIterator();
                return new CommonToken(tokenType, leaf.getText());
            }
            this.next = new CommonToken(semicolonTokenType, leaf.getText());
            return new CommonToken(tokenType, leaf.getText());
        }
        if (leaf.getGrammarElement() == this.rightCurlyInBlock || leaf.getGrammarElement() == this.rightCurlyInArrowExpression) {
            int tokenType = this.tokenTypeMapper.getInternalTokenType(leaf);
            this.next = new CommonToken(tokenType);
            return new CommonToken(this.tokenTypeMapper.getInternalTokenType((EObject)this.semicolon), leaf.getText());
        }
        return this.newSemicolonToken(leaf);
    }

    private Token newSemicolonToken(ILeafNode leaf) {
        int tokenType = this.tokenTypeMapper.getInternalTokenType((EObject)this.semicolon);
        return new CommonToken(tokenType, leaf.getText());
    }

    private Token toPrefixToken(ILeafNode leaf) {
        InternalN4JSLexer lexer = new InternalN4JSLexer();
        String text = leaf.getText();
        String prefix = text.substring(0, this.endOffset - leaf.getTotalOffset());
        ANTLRStringStream stream = new ANTLRStringStream(prefix);
        lexer.setCharStream((CharStream)stream);
        Token nextToken = lexer.nextToken();
        return new CommonToken(nextToken.getType(), nextToken.getText());
    }

    public String getSourceName() {
        return "NodeModelTokenSource";
    }
}

