/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.accessModifiers;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.n4js.n4JS.GetterDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.xtext.scoping.FilterWithErrorMarkerScope;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class ContextAwareTypeScope
extends FilterWithErrorMarkerScope {
    private final boolean isValidLocationForNull;
    private final boolean isValidLocationForVoid;
    private final boolean isValidLocationForFunctionType;

    public ContextAwareTypeScope(IScope parent, EObject context) {
        super(parent);
        EObject container = context.eContainer();
        EReference eRef = context.eContainmentFeature();
        this.isValidLocationForNull = false;
        this.isValidLocationForVoid = eRef == N4JSPackage.eINSTANCE.getFunctionDefinition_ReturnTypeRef() || eRef == TypeRefsPackage.eINSTANCE.getFunctionTypeExpression_ReturnTypeRef() || eRef == TypesPackage.eINSTANCE.getTFunction_ReturnTypeRef() || container instanceof GetterDeclaration && eRef == N4JSPackage.eINSTANCE.getTypedElement_DeclaredTypeRef();
        this.isValidLocationForFunctionType = eRef == N4JSPackage.eINSTANCE.getJSXElement_JsxElementName() || eRef == TypeRefsPackage.eINSTANCE.getTypeTypeRef_TypeArg();
    }

    protected boolean isAccepted(IEObjectDescription originalDescr) {
        EClass eClass = originalDescr.getEClass();
        if (!this.isValidLocationForNull && eClass == TypesPackage.Literals.NULL_TYPE) {
            return false;
        }
        if (!this.isValidLocationForVoid && eClass == TypesPackage.Literals.VOID_TYPE) {
            return false;
        }
        return this.isValidLocationForFunctionType || !TypesPackage.Literals.TFUNCTION.isSuperTypeOf(eClass);
    }

    protected IEObjectDescriptionWithError wrapFilteredDescription(IEObjectDescription originalDescr) {
        EClass eClass = originalDescr.getEClass();
        if (!this.isValidLocationForNull && eClass == TypesPackage.Literals.NULL_TYPE) {
            return null;
        }
        if (!this.isValidLocationForVoid && eClass == TypesPackage.Literals.VOID_TYPE) {
            return new DisallowedTypeDescription(originalDescr, IssueCodes.getMessageForTYS_VOID_AT_WRONG_LOCATION(), "TYS_VOID_AT_WRONG_LOCATION");
        }
        if (!this.isValidLocationForFunctionType && TypesPackage.Literals.TFUNCTION.isSuperTypeOf(eClass)) {
            return new DisallowedTypeDescription(originalDescr, IssueCodes.getMessageForTYS_FUNCTION_DISALLOWED_AS_TYPE(), "TYS_FUNCTION_DISALLOWED_AS_TYPE");
        }
        return null;
    }

    private static final class DisallowedTypeDescription
    extends AbstractDescriptionWithError {
        private final String message;
        private final String issueCode;

        protected DisallowedTypeDescription(IEObjectDescription delegate, String message, String issueCode) {
            super(delegate);
            this.message = message;
            this.issueCode = issueCode;
        }

        public String getMessage() {
            return this.message;
        }

        public String getIssueCode() {
            return this.issueCode;
        }
    }
}

