/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.scoping.members.ComposedMemberInfo;
import org.eclipse.n4js.scoping.members.MemberFactory;
import org.eclipse.n4js.scoping.members.MethodFactory;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TypesFactory;

abstract class SetterFactory
implements MemberFactory {
    final ComposedMemberInfo cma;
    final StandaloneFPar fpar;

    SetterFactory(ComposedMemberInfo cma) {
        this.cma = cma;
        String name = "arg0";
        LinkedList<TypeRef> typeRefs = new LinkedList<TypeRef>();
        List<ComposedMemberInfo.ComposedFParInfo> fpars = cma.getFParAggregates();
        if (fpars != null && !fpars.isEmpty()) {
            ComposedMemberInfo.ComposedFParInfo firstFpar = fpars.get(0);
            name = firstFpar.getName();
            typeRefs.addAll(firstFpar.getTypeRefs());
        }
        this.fpar = new StandaloneFPar(name, typeRefs);
    }

    abstract MemberAccessModifier getAccessability();

    abstract TypeRef getReturnTypeRefComposition();

    public TSetter create(String name) {
        TSetter setter = TypesFactory.eINSTANCE.createTSetter();
        setter.setComposed(true);
        setter.setName(name);
        setter.setDeclaredMemberAccessModifier(this.getAccessability());
        setter.setFpar(this.fpar.create());
        return setter;
    }

    static class IntersectionSetterFactory
    extends SetterFactory {
        IntersectionSetterFactory(ComposedMemberInfo cma) {
            super(cma);
        }

        @Override
        public boolean isValid() {
            return !this.cma.onlyReadOnlyFields();
        }

        @Override
        MemberAccessModifier getAccessability() {
            return this.cma.getAccessabilityMax();
        }

        @Override
        TypeRef getReturnTypeRefComposition() {
            List<TypeRef> typeRefs = this.cma.getTypeRefsOfMemberType(MemberType.SETTER, MemberType.FIELD);
            return this.cma.getTypeSystem().createSimplifiedUnion(typeRefs, this.cma.getResource());
        }

        @Override
        public List<TMember> getConstituentMembers() {
            return this.cma.getConstituentMembers();
        }
    }

    class StandaloneFPar
    extends MethodFactory.FParFactory {
        final String name;
        final List<TypeRef> typeRefs;

        StandaloneFPar(String name, List<TypeRef> typeRefs) {
            this.name = name;
            this.typeRefs = typeRefs;
        }

        @Override
        String getName() {
            return this.name;
        }

        @Override
        List<TypeRef> getTypeRefs() {
            return this.typeRefs;
        }

        @Override
        TypeRef getFParTypeRefComposition(List<TypeRef> typeRefsToUse) {
            return SetterFactory.this.getReturnTypeRefComposition();
        }
    }

    static class UnionSetterFactory
    extends SetterFactory {
        UnionSetterFactory(ComposedMemberInfo cma) {
            super(cma);
        }

        @Override
        public boolean isValid() {
            return !this.cma.hasReadOnlyField();
        }

        @Override
        MemberAccessModifier getAccessability() {
            return this.cma.getAccessabilityMin();
        }

        @Override
        TypeRef getReturnTypeRefComposition() {
            List<TypeRef> typeRefs = this.cma.getTypeRefsOfMemberType(MemberType.SETTER, MemberType.FIELD);
            return this.cma.getTypeSystem().createSimplifiedIntersection(typeRefs, this.cma.getResource());
        }

        @Override
        public List<TMember> getConstituentMembers() {
            return this.cma.getConstituentMembers();
        }
    }
}

