/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.utils;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public abstract class HandlerServiceUtils {
    public static Optional<IEvaluationContext> getCurrentWorkbenchState() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return Optional.absent();
        }
        Object service = PlatformUI.getWorkbench().getService(IHandlerService.class);
        return service instanceof IHandlerService ? Optional.fromNullable((Object)((IHandlerService)service).getCurrentState()) : Optional.absent();
    }

    public static Optional<IEditorPart> getActiveEditor() {
        return HandlerServiceUtils.getActiveEditor(IEditorPart.class);
    }

    public static <T extends IEditorPart> Optional<T> getActiveEditor(Class<T> editorClass) {
        return HandlerServiceUtils.getVariable("activeEditor", editorClass);
    }

    private static <T> Optional<T> getVariable(String variableName, Class<T> expectedClass) {
        if (Strings.isNullOrEmpty((String)variableName) || expectedClass == null) {
            return Optional.absent();
        }
        Optional<IEvaluationContext> state = HandlerServiceUtils.getCurrentWorkbenchState();
        if (!state.isPresent()) {
            return Optional.absent();
        }
        Object variable = ((IEvaluationContext)state.get()).getVariable(variableName);
        if (variable == null || IEvaluationContext.UNDEFINED_VARIABLE == variable) {
            return Optional.absent();
        }
        if (expectedClass.isAssignableFrom(variable.getClass())) {
            return Optional.fromNullable(expectedClass.cast(variable));
        }
        return Optional.absent();
    }
}

