/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.common.unicode.CharTypes;
import org.eclipse.n4js.compileTime.CompileTimeValue;
import org.eclipse.n4js.n4JS.AbstractAnnotationList;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MemberAnnotationList;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.NumericLiteral;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyAssignmentAnnotationList;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameKind;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.resource.XpectAwareFileExtensionCalculator;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.OptionalFieldStrategy;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.util.AllSuperTypesCollector;
import org.eclipse.n4js.ts.types.util.ExtendedClassesIterable;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class N4JSLanguageUtils {
    public static final String SYMBOL_IDENTIFIER_PREFIX = "#";
    public static final String DEFAULT_LANGUAGE_VERSION = "0.0.0.v19990101_0000";
    private static final String LANGUAGE_VERSION_PROPERTIES_FILE_NAME = "language-version.properties";
    private static String languageVersionStr = null;

    public static String getLanguageVersion() {
        if (languageVersionStr != null) {
            return languageVersionStr;
        }
        Properties properties = null;
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = N4JSLanguageUtils.class.getClassLoader().getResourceAsStream(LANGUAGE_VERSION_PROPERTIES_FILE_NAME);){
                Properties _properties;
                if (in == null) {
                    throw new RuntimeException("unable to find properties file language-version.properties");
                }
                properties = _properties = new Properties();
                properties.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                throw new RuntimeException("unable to load properties file language-version.properties", e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        String versionStr = properties.getProperty("language.version");
        if (versionStr == null) {
            throw new RuntimeException("properties file language-version.properties does not contain property language.version");
        }
        languageVersionStr = versionStr;
        return languageVersionStr;
    }

    public static TypeRef makePromiseIfAsync(FunctionDefinition funDef, TypeRef returnTypeRef, BuiltInTypeScope builtInTypeScope) {
        if (funDef != null && returnTypeRef != null) {
            boolean _isAsync = funDef.isAsync();
            if (_isAsync) {
                return TypeUtils.createPromiseTypeRef((BuiltInTypeScope)builtInTypeScope, (TypeArgument)returnTypeRef, null);
            }
            return returnTypeRef;
        }
        return null;
    }

    public static TypeRef makeGeneratorIfGeneratorFunction(FunctionDefinition funDef, TypeRef returnTypeRef, BuiltInTypeScope builtInTypeScope) {
        if (funDef != null && returnTypeRef != null) {
            boolean _isGenerator = funDef.isGenerator();
            if (_isGenerator) {
                return TypeUtils.createGeneratorTypeRef((BuiltInTypeScope)builtInTypeScope, (FunctionDefinition)funDef);
            }
            return returnTypeRef;
        }
        return null;
    }

    public static boolean isASTNode(EObject obj) {
        Script _containerOfType = (Script)EcoreUtil2.getContainerOfType((EObject)obj, Script.class);
        return _containerOfType != null;
    }

    public static boolean isUndefinedLiteral(RuleEnvironment G, Expression expr) {
        if (expr instanceof IdentifierRef) {
            TField _fieldUndefined;
            IdentifiableElement _id = ((IdentifierRef)expr).getId();
            return _id == (_fieldUndefined = RuleEnvironmentExtensions.getGlobalObjectScope(G).getFieldUndefined());
        }
        return false;
    }

    public static boolean isTypeModelElement(EObject obj) {
        TModule _containerOfType = (TModule)EcoreUtil2.getContainerOfType((EObject)obj, TModule.class);
        return _containerOfType != null;
    }

    public static boolean isTypableNode(EObject astNode) {
        return astNode instanceof TypableElement && !(astNode instanceof AbstractAnnotationList);
    }

    public static boolean isIdentifiableSubtree(EObject astNode) {
        return astNode instanceof IdentifiableElement || N4JSLanguageUtils.getDefinedTypeModelElement(astNode) instanceof IdentifiableElement || astNode instanceof FunctionDeclaration || astNode instanceof N4ClassDeclaration;
    }

    public static boolean isTypeModelElementDefiningASTNode(EObject astNode) {
        return astNode instanceof ExportedVariableDeclaration || astNode instanceof TypeDefiningElement || astNode instanceof N4MemberDeclaration && !(astNode instanceof N4MemberAnnotationList) || astNode instanceof PropertyAssignment && !(astNode instanceof PropertyAssignmentAnnotationList) || astNode instanceof FormalParameter || astNode instanceof TStructMember || astNode instanceof N4EnumLiteral;
    }

    public static EObject getDefinedTypeModelElement(EObject astNode) {
        boolean _isASTNode;
        TVariable _switchResult = null;
        boolean _matched = false;
        if (astNode instanceof ExportedVariableDeclaration) {
            _matched = true;
            _switchResult = ((ExportedVariableDeclaration)astNode).getDefinedVariable();
        }
        if (!_matched && astNode instanceof PropertyMethodDeclaration) {
            _matched = true;
            _switchResult = ((PropertyMethodDeclaration)astNode).getDefinedMember();
        }
        if (!_matched && astNode instanceof TypeDefiningElement) {
            _matched = true;
            _switchResult = ((TypeDefiningElement)astNode).getDefinedType();
        }
        if (!_matched && astNode instanceof N4MemberDeclaration && !(astNode instanceof N4MemberAnnotationList)) {
            _matched = true;
            _switchResult = ((N4MemberDeclaration)astNode).getDefinedTypeElement();
        }
        if (!_matched && astNode instanceof PropertyAssignment && !(astNode instanceof PropertyAssignmentAnnotationList)) {
            _matched = true;
            _switchResult = ((PropertyAssignment)astNode).getDefinedMember();
        }
        if (!_matched && astNode instanceof FormalParameter) {
            _matched = true;
            _switchResult = ((FormalParameter)astNode).getDefinedTypeElement();
        }
        if (!_matched && astNode instanceof TStructMember && (_isASTNode = N4JSLanguageUtils.isASTNode(astNode))) {
            _matched = true;
            _switchResult = ((TStructMember)astNode).getDefinedMember();
        }
        if (!_matched && astNode instanceof N4EnumLiteral) {
            _matched = true;
            _switchResult = ((N4EnumLiteral)astNode).getDefinedLiteral();
        }
        if (!_matched && astNode instanceof TypeVariable && (_isASTNode = N4JSLanguageUtils.isASTNode(astNode))) {
            _matched = true;
            _switchResult = ((TypeVariable)astNode).getDefinedTypeVariable();
        }
        return _switchResult;
    }

    public static boolean isConstructor(TMember it) {
        return it instanceof TMethod && Objects.equal((Object)"constructor", (Object)it.getName());
    }

    public static boolean isWriteableField(TMember m) {
        return m instanceof TField && m.isWriteable();
    }

    public static boolean isReadOnlyField(TMember m) {
        return m instanceof TField && !m.isWriteable();
    }

    public static boolean isExported(IdentifiableElement elem) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (elem instanceof ExportedVariableDeclaration) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && elem instanceof TVariable) {
            _matched = true;
            _switchResult = ((TVariable)elem).isExported();
        }
        if (!_matched && elem instanceof Type) {
            _matched = true;
            _switchResult = ((Type)elem).isExported();
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isAsync(TFunction tfunction, BuiltInTypeScope scope) {
        TypeRef _returnTypeRef;
        boolean _isDeclaredAsync = tfunction.isDeclaredAsync();
        if (_isDeclaredAsync && (_returnTypeRef = tfunction.getReturnTypeRef()) instanceof ParameterizedTypeRef) {
            return TypeUtils.isPromise((TypeRef)tfunction.getReturnTypeRef(), (BuiltInTypeScope)scope);
        }
        return false;
    }

    public static boolean isAsync(FunctionTypeExprOrRef fteor, RuleEnvironment G) {
        TFunction tfunction = fteor.getFunctionType();
        BuiltInTypeScope tscope = RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope;
        if (tfunction == null) {
            return TypeUtils.isPromise((TypeRef)fteor.getReturnTypeRef(), (BuiltInTypeScope)tscope);
        }
        return N4JSLanguageUtils.isAsync(tfunction, tscope);
    }

    public static boolean isInstantiable(TypeTypeRef typeTypeRef) {
        TypeArgument typeArg = typeTypeRef.getTypeArg();
        if (typeArg instanceof Wildcard || typeArg instanceof ExistentialTypeRef) {
            return false;
        }
        Type pseudoStaticType = ((TypeRef)typeArg).getDeclaredType();
        return pseudoStaticType instanceof TN4Classifier || pseudoStaticType instanceof TObjectPrototype;
    }

    public static Variance getVarianceOfPosition(TypeRef typeRef) {
        Variance v1 = N4JSLanguageUtils.getVarianceOfPositionInClassifier(typeRef);
        if (v1 == null || v1 == Variance.INV) {
            return v1;
        }
        Variance v2 = N4JSLanguageUtils.getVarianceOfPositionRelativeToItsRoot(typeRef);
        return v1.mult(v2);
    }

    public static Variance getVarianceOfPositionInClassifier(TypeRef typeRef) {
        TClassifier tClassifier;
        if (typeRef == null) {
            return null;
        }
        TypeRef rootTypeRef = TypeUtils.getRootTypeRef((TypeRef)typeRef);
        N4ClassifierDeclaration _containerOfType = (N4ClassifierDeclaration)EcoreUtil2.getContainerOfType((EObject)rootTypeRef, N4ClassifierDeclaration.class);
        Type _definedType = null;
        if (_containerOfType != null) {
            _definedType = _containerOfType.getDefinedType();
        }
        if ((tClassifier = (TClassifier)_definedType) == null) {
            return null;
        }
        EObject parent = rootTypeRef.eContainer();
        EObject _eContainer = null;
        if (parent != null) {
            _eContainer = parent.eContainer();
        }
        EObject grandParent = _eContainer;
        Variance _switchResult = null;
        boolean _matched = false;
        if (parent instanceof FormalParameter && ((FormalParameter)parent).getDeclaredTypeRef() == rootTypeRef && N4JSLanguageUtils.isNonPrivateMemberOf(grandParent, tClassifier)) {
            _matched = true;
            _switchResult = Variance.CONTRA;
        }
        if (!_matched && parent instanceof N4MethodDeclaration && ((N4MethodDeclaration)parent).getReturnTypeRef() == rootTypeRef && N4JSLanguageUtils.isNonPrivateMemberOf(parent, tClassifier)) {
            _matched = true;
            _switchResult = Variance.CO;
        }
        if (!_matched && parent instanceof N4GetterDeclaration && ((N4GetterDeclaration)parent).getDeclaredTypeRef() == rootTypeRef && N4JSLanguageUtils.isNonPrivateMemberOf(parent, tClassifier)) {
            _matched = true;
            _switchResult = Variance.CO;
        }
        if (!_matched && parent instanceof N4FieldDeclaration && ((N4FieldDeclaration)parent).getDeclaredTypeRef() == rootTypeRef && N4JSLanguageUtils.isNonPrivateMemberOf(parent, tClassifier)) {
            _matched = true;
            Variance _xblockexpression = null;
            TField tField = ((N4FieldDeclaration)parent).getDefinedField();
            Variance _xifexpression = null;
            boolean _isFinal = tField.isFinal();
            _xifexpression = _isFinal ? Variance.CO : Variance.INV;
            _switchResult = _xblockexpression = _xifexpression;
        }
        if (!_matched && parent instanceof N4ClassifierDeclaration) {
            Functions.Function1 _function = it -> it == rootTypeRef;
            boolean _exists = IterableExtensions.exists((Iterable)((N4ClassifierDeclaration)parent).getSuperClassifierRefs(), (Functions.Function1)_function);
            if (_exists) {
                _matched = true;
                _switchResult = Variance.CO;
            }
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    public static Variance getVarianceOfPositionRelativeToItsRoot(TypeRef typeRef) {
        Variance v = Variance.CO;
        TypeRef curr = typeRef;
        while (curr != null) {
            TypeRef parent = (TypeRef)EcoreUtil2.getContainerOfType((EObject)curr.eContainer(), TypeRef.class);
            if (parent != null) {
                Variance vFactor = null;
                Type parentDeclType = parent.getDeclaredType();
                EList parentTypeArgs = parent.getTypeArgs();
                int parentTypeArgsSize = parentTypeArgs.size();
                int idx = 0;
                while (vFactor == null && idx < parentTypeArgsSize) {
                    TypeArgument arg = (TypeArgument)parentTypeArgs.get(idx);
                    Variance _xifexpression = null;
                    if (arg == curr) {
                        Variance incomingVariance;
                        Variance _xblockexpression = null;
                        TypeVariable _xifexpression_1 = null;
                        _xifexpression_1 = idx >= 0 && idx < parentDeclType.getTypeVars().size() ? (TypeVariable)parentDeclType.getTypeVars().get(idx) : null;
                        TypeVariable correspondingTypeVar = _xifexpression_1;
                        Variance _elvis = null;
                        Variance _variance = null;
                        if (correspondingTypeVar != null) {
                            _variance = correspondingTypeVar.getVariance();
                        }
                        _elvis = _variance != null ? _variance : Variance.CO;
                        _xifexpression = _xblockexpression = (incomingVariance = _elvis);
                    } else {
                        Variance _xifexpression_1 = null;
                        if (arg instanceof Wildcard) {
                            boolean _tripleEquals;
                            Variance _xifexpression_2 = null;
                            TypeRef _declaredUpperBound = ((Wildcard)arg).getDeclaredUpperBound();
                            boolean bl = _tripleEquals = _declaredUpperBound == curr;
                            if (_tripleEquals) {
                                _xifexpression_2 = Variance.CO;
                            } else {
                                boolean _tripleEquals_1;
                                Variance _xifexpression_3 = null;
                                TypeRef _declaredLowerBound = ((Wildcard)arg).getDeclaredLowerBound();
                                boolean bl2 = _tripleEquals_1 = _declaredLowerBound == curr;
                                if (_tripleEquals_1) {
                                    _xifexpression_3 = Variance.CONTRA;
                                }
                                _xifexpression_2 = _xifexpression_3;
                            }
                            _xifexpression_1 = _xifexpression_2;
                        }
                        _xifexpression = _xifexpression_1;
                    }
                    vFactor = _xifexpression;
                    ++idx;
                }
                if (vFactor == null) {
                    TypeArgument _typeArg;
                    boolean _contains;
                    TypeRef currFixed = curr;
                    Variance _switchResult = null;
                    boolean _matched = false;
                    if (parent instanceof ComposedTypeRef && (_contains = ((ComposedTypeRef)parent).getTypeRefs().contains((Object)curr))) {
                        _matched = true;
                        _switchResult = Variance.CO;
                    }
                    if (!_matched && parent instanceof TypeTypeRef) {
                        boolean _tripleEquals;
                        TypeArgument _typeArg2 = ((TypeTypeRef)parent).getTypeArg();
                        boolean bl = _tripleEquals = _typeArg2 == curr;
                        if (_tripleEquals) {
                            _matched = true;
                            Variance _xifexpression = null;
                            boolean _isConstructorRef = ((TypeTypeRef)parent).isConstructorRef();
                            _xifexpression = _isConstructorRef ? Variance.INV : Variance.CO;
                            _switchResult = _xifexpression;
                        }
                    }
                    if (!_matched && parent instanceof TypeTypeRef && (_typeArg = ((TypeTypeRef)parent).getTypeArg()) instanceof Wildcard) {
                        boolean _tripleEquals;
                        _matched = true;
                        Variance _xblockexpression = null;
                        TypeArgument _typeArg_1 = ((TypeTypeRef)parent).getTypeArg();
                        Wildcard wc = (Wildcard)_typeArg_1;
                        Variance _xifexpression = null;
                        TypeRef _declaredUpperBound = wc.getDeclaredUpperBound();
                        boolean bl = _tripleEquals = _declaredUpperBound == curr;
                        if (_tripleEquals) {
                            _xifexpression = Variance.CO;
                        } else {
                            boolean _tripleEquals_1;
                            Variance _xifexpression_1 = null;
                            TypeRef _declaredLowerBound = wc.getDeclaredLowerBound();
                            boolean bl3 = _tripleEquals_1 = _declaredLowerBound == curr;
                            if (_tripleEquals_1) {
                                _xifexpression_1 = Variance.CONTRA;
                            }
                            _xifexpression = _xifexpression_1;
                        }
                        _switchResult = _xblockexpression = _xifexpression;
                    }
                    if (!_matched && parent instanceof BoundThisTypeRef) {
                        boolean _tripleEquals;
                        ParameterizedTypeRef _actualThisTypeRef = ((BoundThisTypeRef)parent).getActualThisTypeRef();
                        boolean bl = _tripleEquals = _actualThisTypeRef == curr;
                        if (_tripleEquals) {
                            _matched = true;
                            _switchResult = Variance.CO;
                        }
                    }
                    if (!_matched && parent instanceof FunctionTypeExpression) {
                        boolean _tripleEquals;
                        TypeRef _returnTypeRef = ((FunctionTypeExpression)parent).getReturnTypeRef();
                        boolean bl = _tripleEquals = _returnTypeRef == curr;
                        if (_tripleEquals) {
                            _matched = true;
                            _switchResult = Variance.CO;
                        }
                    }
                    if (!_matched && parent instanceof FunctionTypeExpression) {
                        Functions.Function1 _function = it -> {
                            TypeRef _typeRef = it.getTypeRef();
                            return _typeRef == currFixed;
                        };
                        boolean _exists = IterableExtensions.exists((Iterable)((FunctionTypeExpression)parent).getFpars(), (Functions.Function1)_function);
                        if (_exists) {
                            _matched = true;
                            _switchResult = Variance.CONTRA;
                        }
                    }
                    vFactor = _switchResult;
                }
                if (vFactor == null) {
                    throw new IllegalStateException("internal error: unsupported case of containment of one typeRef in another (maybe types model has changed?)");
                }
                if ((v = v.mult(vFactor)) == Variance.INV) {
                    return v;
                }
            }
            curr = parent;
        }
        return v;
    }

    private static boolean isNonPrivateMemberOf(EObject member, TClassifier tClassifier) {
        if (member instanceof N4MemberDeclaration) {
            TMember tMember = ((N4MemberDeclaration)member).getDefinedTypeElement();
            return tMember != null && !tMember.isConstructor() && tMember.getMemberAccessModifier() != MemberAccessModifier.PRIVATE && tMember.getContainingType() == tClassifier;
        }
        return false;
    }

    public static boolean isIntLiteral(NumericLiteral numLit) {
        EObject parent = numLit.eContainer();
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)numLit);
        String text = NodeModelUtils.getTokenText((INode)node);
        int result = N4JSLanguageUtils.isIntLiteral(text);
        if (result == 2) {
            return parent instanceof UnaryExpression && ((UnaryExpression)parent).getOp() == UnaryOperator.NEG;
        }
        return result == 1;
    }

    public static int isIntLiteral(String numLitStr) {
        long value;
        block9: {
            if (numLitStr == null || numLitStr.length() == 0) {
                return 0;
            }
            boolean hasFractionOrExponent = N4JSLanguageUtils.containsOneOf(numLitStr, '.', 'e', 'E');
            if (hasFractionOrExponent) {
                return 0;
            }
            try {
                boolean isHex = numLitStr.startsWith("0x") || numLitStr.startsWith("0X");
                boolean isOct = !isHex && numLitStr.startsWith("0") && numLitStr.length() > 1 && !N4JSLanguageUtils.containsOneOf(numLitStr, '8', '9');
                long _xifexpression = 0L;
                if (isHex) {
                    _xifexpression = Long.parseLong(numLitStr.substring(2), 16);
                } else {
                    long _xifexpression_1 = 0L;
                    _xifexpression_1 = isOct ? Long.parseLong(numLitStr.substring(1), 8) : Long.parseLong(numLitStr);
                    _xifexpression = _xifexpression_1;
                }
                value = _xifexpression;
                if (value != 0x80000000L) break block9;
                return 2;
            }
            catch (Throwable _t) {
                if (_t instanceof NumberFormatException) {
                    return 0;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            return 1;
        }
        return 0;
    }

    private static boolean containsOneOf(String str, char ... ch) {
        int len = str.length();
        int i = 0;
        while (i < len) {
            char chStr = str.charAt(i);
            int j = 0;
            while (j < ch.length) {
                boolean _tripleEquals;
                char _get = ch[j];
                boolean bl = _tripleEquals = chStr == _get;
                if (_tripleEquals) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPolyfill(AnnotableElement astElement) {
        return AnnotationDefinition.POLYFILL.hasAnnotation(astElement);
    }

    public static boolean isStaticPolyfill(AnnotableElement astElement) {
        return AnnotationDefinition.STATIC_POLYFILL.hasAnnotation(astElement);
    }

    public static boolean isContainedInStaticPolyfillModule(AnnotableElement astElement) {
        return AnnotationDefinition.STATIC_POLYFILL_MODULE.hasAnnotation(astElement);
    }

    public static boolean isContainedInStaticPolyfillModule(TAnnotableElement tsElement) {
        return AnnotationDefinition.STATIC_POLYFILL_MODULE.hasAnnotation(tsElement);
    }

    public static boolean isContainedInStaticPolyfillAware(AnnotableElement astElement) {
        return AnnotationDefinition.STATIC_POLYFILL_AWARE.hasAnnotation(astElement);
    }

    public static boolean isContainedInStaticPolyfillAware(TAnnotableElement tsElement) {
        return AnnotationDefinition.STATIC_POLYFILL_AWARE.hasAnnotation(tsElement);
    }

    public static boolean isDefaultExport(QualifiedName qualifiedName) {
        return qualifiedName != null && qualifiedName.getSegmentCount() > 1 && Objects.equal((Object)qualifiedName.getLastSegment(), (Object)"default");
    }

    public static String lastSegmentOrDefaultHost(QualifiedName qualifiedName) {
        boolean _isDefaultExport = N4JSLanguageUtils.isDefaultExport(qualifiedName);
        if (_isDefaultExport) {
            int _segmentCount = qualifiedName.getSegmentCount();
            int _minus = _segmentCount - 2;
            return qualifiedName.getSegment(_minus);
        }
        return qualifiedName.getLastSegment();
    }

    public static boolean isValidIdentifierStart(char c) {
        return CharTypes.isLetter((int)c) || N4JSLanguageUtils.isChar(c, "_") || N4JSLanguageUtils.isChar(c, "$");
    }

    public static boolean isValidIdentifierPart(char c) {
        return N4JSLanguageUtils.isValidIdentifierStart(c) || CharTypes.isDigit((int)c) || CharTypes.isConnectorPunctuation((int)c) || CharTypes.isCombiningMark((int)c) || N4JSLanguageUtils.isChar(c, "\u200c") || N4JSLanguageUtils.isChar(c, "\u200d");
    }

    public static boolean isValidIdentifier(String identifier) {
        int[] characters = identifier.chars().toArray();
        int _length = characters.length;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _length, true);
        for (Integer i : _doubleDotLessThan) {
            boolean _not_1;
            int _get = characters[i];
            char c = (char)_get;
            if (i == 0) {
                boolean _not;
                boolean _isValidIdentifierStart = N4JSLanguageUtils.isValidIdentifierStart(c);
                boolean bl = _not = !_isValidIdentifierStart;
                if (!_not) continue;
                return false;
            }
            boolean _isValidIdentifierPart = N4JSLanguageUtils.isValidIdentifierPart(c);
            boolean bl = _not_1 = !_isValidIdentifierPart;
            if (!_not_1) continue;
            return false;
        }
        return true;
    }

    private static boolean isChar(char c1, String c2) {
        char _charAt = c2.charAt(0);
        return c1 == _charAt;
    }

    public static TField getAccessedBuiltInSymbol(RuleEnvironment G, Expression expr) {
        return N4JSLanguageUtils.getAccessedBuiltInSymbol(G, expr, true);
    }

    public static TField getAccessedBuiltInSymbol(RuleEnvironment G, Expression expr, boolean allowProxyResolution) {
        if (expr instanceof ParameterizedPropertyAccessExpression) {
            TObjectPrototype sym = RuleEnvironmentExtensions.symbolObjectType(G);
            if (allowProxyResolution) {
                IdentifiableElement prop = ((ParameterizedPropertyAccessExpression)expr).getProperty();
                if (prop instanceof TField && prop.eContainer() == sym) {
                    return (TField)prop;
                }
            } else {
                IdentifiableElement targetElem;
                Expression targetExpr = ((ParameterizedPropertyAccessExpression)expr).getTarget();
                IdentifiableElement _xifexpression = null;
                if (targetExpr instanceof IdentifierRef) {
                    _xifexpression = ((IdentifierRef)targetExpr).getId();
                }
                if ((targetElem = _xifexpression) == sym) {
                    String propName = ((ParameterizedPropertyAccessExpression)expr).getPropertyAsText();
                    Functions.Function1 _function = it -> it.isStatic() && Objects.equal((Object)it.getName(), (Object)propName);
                    return (TField)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)sym.getOwnedMembers(), TField.class), (Functions.Function1)_function);
                }
            }
        }
        return null;
    }

    public static boolean hasCovariantConstructor(TClassifier tClassifier) {
        return tClassifier.isDeclaredCovariantConstructor() || IterableExtensions.exists((Iterable)AllSuperTypesCollector.collect((ContainerType)tClassifier), it -> it.isDeclaredCovariantConstructor());
    }

    public static TClass findCovariantConstructorDeclarator(TClass tClass) {
        Functions.Function1 _function = it -> it.isDeclaredCovariantConstructor();
        return (TClass)IterableExtensions.findFirst((Iterable)new ExtendedClassesIterable(tClass), (Functions.Function1)_function);
    }

    public static TypeRef getTypeVariableImplicitUpperBound(RuleEnvironment G) {
        return RuleEnvironmentExtensions.anyTypeRef(G);
    }

    public static boolean isProcessedAsCompileTimeExpression(Expression expr) {
        boolean _isMandatoryCompileTimeExpression = N4JSLanguageUtils.isMandatoryCompileTimeExpression(expr);
        if (_isMandatoryCompileTimeExpression) {
            return true;
        }
        EObject parent = expr.eContainer();
        return parent instanceof ExportedVariableDeclaration || parent instanceof N4FieldDeclaration;
    }

    public static boolean isMandatoryCompileTimeExpression(Expression expr) {
        EObject parent = expr.eContainer();
        if (parent instanceof LiteralOrComputedPropertyName) {
            return ((LiteralOrComputedPropertyName)parent).getKind() == PropertyNameKind.COMPUTED && ((LiteralOrComputedPropertyName)parent).getExpression() == expr;
        }
        if (parent instanceof IndexedAccessExpression) {
            Expression _index = ((IndexedAccessExpression)parent).getIndex();
            return _index == expr;
        }
        return false;
    }

    public static String derivePropertyNameFromCompileTimeValue(CompileTimeValue value) {
        String _xifexpression = null;
        _xifexpression = value != null && value.isValid() ? value.toString() : null;
        return _xifexpression;
    }

    public static OptionalFieldStrategy calculateOptionalFieldStrategy(TypableElement expr, TypeRef typeRef) {
        boolean _isConstTransitiveObjectLiteral = N4JSLanguageUtils.isConstTransitiveObjectLiteral(expr);
        if (_isConstTransitiveObjectLiteral) {
            return OptionalFieldStrategy.FIELDS_AND_ACCESSORS_OPTIONAL;
        }
        boolean _isConstTransitiveNewExpressionOrFinalNominalClassInstance = N4JSLanguageUtils.isConstTransitiveNewExpressionOrFinalNominalClassInstance(expr, typeRef);
        if (_isConstTransitiveNewExpressionOrFinalNominalClassInstance) {
            return OptionalFieldStrategy.GETTERS_OPTIONAL;
        }
        if (expr instanceof ConditionalExpression) {
            OptionalFieldStrategy optionalStrategyForTrueExpr = N4JSLanguageUtils.calculateOptionalFieldStrategy((TypableElement)((ConditionalExpression)expr).getTrueExpression(), typeRef);
            OptionalFieldStrategy optionalStrategyForFalseExpr = N4JSLanguageUtils.calculateOptionalFieldStrategy((TypableElement)((ConditionalExpression)expr).getFalseExpression(), typeRef);
            return N4JSLanguageUtils.minOptionalityFieldStrategy(optionalStrategyForTrueExpr, optionalStrategyForFalseExpr);
        }
        return OptionalFieldStrategy.OFF;
    }

    private static boolean isConstTransitiveObjectLiteral(TypableElement expr) {
        if (expr instanceof NullLiteral) {
            return true;
        }
        if (expr instanceof ObjectLiteral) {
            return true;
        }
        if (expr instanceof IdentifierRef) {
            IdentifiableElement idElem = ((IdentifierRef)expr).getId();
            if (idElem instanceof VariableDeclaration) {
                boolean _isConst = ((VariableDeclaration)idElem).isConst();
                if (_isConst) {
                    Expression _expression = ((VariableDeclaration)idElem).getExpression();
                    return _expression instanceof ObjectLiteral;
                }
            } else if (idElem instanceof TVariable) {
                return ((TVariable)idElem).isObjectLiteral();
            }
        }
        return false;
    }

    private static boolean isConstTransitiveNewExpressionOrFinalNominalClassInstance(TypableElement expr, TypeRef typeRef) {
        Type declType;
        if (expr instanceof NullLiteral) {
            return true;
        }
        if (expr instanceof NewExpression) {
            return true;
        }
        if (typeRef != null && (declType = typeRef.getDeclaredType()) != null && declType.isFinal() && Objects.equal((Object)typeRef.getTypingStrategy(), (Object)TypingStrategy.NOMINAL)) {
            return true;
        }
        if (expr instanceof IdentifierRef) {
            IdentifiableElement idElem = ((IdentifierRef)expr).getId();
            if (idElem instanceof VariableDeclaration) {
                boolean _isConst = ((VariableDeclaration)idElem).isConst();
                if (_isConst) {
                    Expression _expression = ((VariableDeclaration)idElem).getExpression();
                    return _expression instanceof NewExpression;
                }
            } else if (idElem instanceof TVariable) {
                return ((TVariable)idElem).isNewExpression();
            }
        }
        return false;
    }

    public static boolean builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation(TInterface tinf) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)AnnotationDefinition.N4JS.name, (Object)_name);
        };
        boolean hasN4JSAnnotation = IterableExtensions.exists((Iterable)tinf.getAnnotations(), (Functions.Function1)_function);
        TypingStrategy ts = tinf.getTypingStrategy();
        boolean isDefStructural = !Objects.equal((Object)ts, (Object)TypingStrategy.NOMINAL) && !Objects.equal((Object)ts, (Object)TypingStrategy.DEFAULT);
        XpectAwareFileExtensionCalculator fileExtensionCalculator = new XpectAwareFileExtensionCalculator();
        String fileExt = fileExtensionCalculator.getXpectAwareFileExtension((EObject)tinf);
        return TypeUtils.isBuiltIn((Type)tinf) || tinf.isProvidedByRuntime() || tinf.isExternal() && !hasN4JSAnnotation || isDefStructural && Objects.equal((Object)fileExt, (Object)"n4jsd");
    }

    public static boolean isOptionalityLessRestrictedOrEqual(OptionalFieldStrategy s1, OptionalFieldStrategy s2) {
        boolean _switchResult;
        block7: {
            block6: {
                boolean _equals = Objects.equal((Object)s1, (Object)s2);
                if (_equals) {
                    return true;
                }
                _switchResult = false;
                if (s1 == null) break block6;
                switch (s1) {
                    case FIELDS_AND_ACCESSORS_OPTIONAL: {
                        _switchResult = true;
                        break block7;
                    }
                    case OFF: {
                        _switchResult = Objects.equal((Object)s2, (Object)OptionalFieldStrategy.OFF);
                        break block7;
                    }
                    case GETTERS_OPTIONAL: {
                        _switchResult = Objects.equal((Object)s2, (Object)OptionalFieldStrategy.GETTERS_OPTIONAL) || Objects.equal((Object)s2, (Object)OptionalFieldStrategy.OFF);
                        break block7;
                    }
                    default: {
                        throw new RuntimeException("Invalid enum value " + s1);
                    }
                }
            }
            throw new RuntimeException("Invalid enum value " + s1);
        }
        boolean result = _switchResult;
        return result;
    }

    public static OptionalFieldStrategy minOptionalityFieldStrategy(OptionalFieldStrategy s1, OptionalFieldStrategy s2) {
        if (Objects.equal((Object)s1, (Object)OptionalFieldStrategy.FIELDS_AND_ACCESSORS_OPTIONAL) && Objects.equal((Object)s2, (Object)OptionalFieldStrategy.FIELDS_AND_ACCESSORS_OPTIONAL)) {
            return OptionalFieldStrategy.FIELDS_AND_ACCESSORS_OPTIONAL;
        }
        if (!Objects.equal((Object)s1, (Object)OptionalFieldStrategy.OFF) && !Objects.equal((Object)s2, (Object)OptionalFieldStrategy.OFF)) {
            return OptionalFieldStrategy.GETTERS_OPTIONAL;
        }
        return OptionalFieldStrategy.OFF;
    }
}

