/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.workingsets.DefaultWorkingSetImpl;
import org.eclipse.n4js.ui.workingsets.MutableWorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetEditWizard;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerImpl;
import org.eclipse.n4js.ui.workingsets.WorkingSetNewWizard;
import org.eclipse.n4js.ui.workingsets.WorkingSetProjectNameFilterWizard;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.swt.graphics.Image;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectNameFilterAwareWorkingSetManager
extends WorkingSetManagerImpl
implements MutableWorkingSetManager {
    private static final Logger LOGGER = Logger.getLogger(ProjectNameFilterAwareWorkingSetManager.class);
    private static final String ORDERED_FILTERS_KEY = ".orderedFilters";
    private final List<String> orderedWorkingSetFilters = Lists.newArrayList();
    @Inject
    private Provider<WorkingSetProjectNameFilterWizard> wizardProvider;

    @Override
    public String getLabel() {
        return "Project Name Filter";
    }

    @Override
    public Optional<Image> getImage() {
        return ImageDescriptorCache.ImageRef.VARIABLE_TAB.asImage();
    }

    @Override
    public IStatus saveState(IProgressMonitor monitor) {
        IStatus superSaveResult = super.saveState(monitor);
        if (superSaveResult.isOK()) {
            Preferences node = this.getPreferences();
            node.put(ORDERED_FILTERS_KEY, Joiner.on((String)"#").join(this.orderedWorkingSetFilters));
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                String message = "Error occurred while saving state to preference store.";
                LOGGER.error((Object)"Error occurred while saving state to preference store.", (Throwable)e);
                return this.statusHelper.createError("Error occurred while saving state to preference store.", (Throwable)e);
            }
            return this.statusHelper.OK();
        }
        return superSaveResult;
    }

    @Override
    public IStatus restoreState(IProgressMonitor monitor) {
        IStatus superRestoreResult = super.restoreState(monitor);
        if (superRestoreResult.isOK()) {
            Preferences node = this.getPreferences();
            String orderedFilters = node.get(ORDERED_FILTERS_KEY, "");
            if (!Strings.isNullOrEmpty((String)orderedFilters)) {
                this.orderedWorkingSetFilters.clear();
                this.orderedWorkingSetFilters.addAll(Arrays.asList(orderedFilters.split("#")));
            }
            this.discardWorkingSetCaches();
            return this.statusHelper.OK();
        }
        return superRestoreResult;
    }

    @Override
    public void updateState(Diff<WorkingSet> diff) {
        super.updateState(diff);
        if (!diff.isEmpty()) {
            this.orderedWorkingSetFilters.clear();
            WorkingSet[] workingSetArray = (WorkingSet[])diff.getNewAllItems();
            int n = workingSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorkingSet workingSet = workingSetArray[n2];
                ProjectNameFilterWorkingSet nameFilterWorkingSet = (ProjectNameFilterWorkingSet)workingSet;
                this.orderedWorkingSetFilters.add(nameFilterWorkingSet.getFilter().pattern());
                ++n2;
            }
            this.discardWorkingSetCaches();
            this.getWorkingSetManagerBroker().fireWorkingSetManagerUpdated(this.getId(), diff);
        }
    }

    @Override
    protected List<WorkingSet> initializeWorkingSets() {
        Preconditions.checkState((this.orderedWorkingSetFilters.size() == this.orderedWorkingSetIds.size() ? 1 : 0) != 0, (Object)("Expected same number of working set names as working set filters.\nNames were: " + Iterables.toString((Iterable)this.orderedWorkingSetIds) + "\nFilters were: " + Iterables.toString(this.orderedWorkingSetFilters)));
        if (this.orderedWorkingSetFilters.isEmpty()) {
            this.orderedWorkingSetFilters.add("Other Projects");
            this.orderedWorkingSetIds.add("Other Projects");
        }
        int size = this.orderedWorkingSetFilters.size();
        WorkingSet[] workingSets = new WorkingSet[size];
        int i = 0;
        while (i < size) {
            String regex = this.orderedWorkingSetFilters.get(i);
            String name = (String)this.orderedWorkingSetIds.get(i);
            workingSets[i] = new ProjectNameFilterWorkingSet(Pattern.compile(regex), name, this);
            ++i;
        }
        return Arrays.asList(workingSets);
    }

    @Override
    protected void discardWorkingSetState() {
        super.discardWorkingSetState();
        this.orderedWorkingSetFilters.clear();
    }

    @Override
    public WorkingSetNewWizard createNewWizard() {
        return (WorkingSetNewWizard)((Object)this.wizardProvider.get());
    }

    @Override
    public WorkingSetEditWizard createEditWizard() {
        return (WorkingSetEditWizard)((Object)this.wizardProvider.get());
    }

    public static final class ProjectNameFilterWorkingSet
    extends DefaultWorkingSetImpl {
        private final Pattern filter;

        @VisibleForTesting
        public ProjectNameFilterWorkingSet(Pattern filter, String id, WorkingSetManager manager) {
            super(id, manager);
            this.filter = filter;
        }

        public boolean apply(IProject project) {
            return this.filter.matcher(project.getName()).matches();
        }

        public Pattern getFilter() {
            return this.filter;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " [" + this.filter + "]";
        }
    }
}

