/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.util.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexedSet<K, V> {
    private final Set<V> set = new HashSet<V>();
    private final Set<V> unmodifiable = Collections.unmodifiableSet(this.set);
    private final Map<K, V> index = new HashMap();

    public Set<V> getItemSet() {
        return this.unmodifiable;
    }

    public V getItemByKey(K key) {
        return this.index.get(key);
    }

    public boolean containsKey(K key) {
        return this.index.containsKey(key);
    }

    public boolean containsItem(V item) {
        return this.set.contains(item);
    }

    public void addItem(V item) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        this.set.add(item);
    }

    public void addItemWithKey(K key, V item) {
        this.addItem(item);
        this.addKey(key, item);
    }

    public void addKey(K key, V item) {
        if (key == null || item == null) {
            throw new IllegalArgumentException();
        }
        if (!this.set.contains(item)) {
            throw new IllegalArgumentException();
        }
        this.index.put(key, item);
    }

    public boolean removeItem(V item) {
        if (this.set.remove(item)) {
            Iterator<Map.Entry<K, V>> itr = this.index.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<K, V> entry = itr.next();
                if (entry.getValue() != item) continue;
                itr.remove();
            }
            return true;
        }
        return false;
    }

    public boolean removeItemByKey(K key) {
        V item = this.index.get(key);
        if (item != null) {
            return this.removeItem(item);
        }
        return false;
    }
}

