/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contenttype;

import java.util.EmptyStackException;

public class IntStack {
    private int[] list = null;
    private int size = 0;

    public IntStack() {
        this(100);
    }

    public IntStack(int maxdepth) {
        this.list = new int[maxdepth];
        this.initialize();
    }

    public void clear() {
        this.initialize();
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int get(int slot) {
        return this.list[slot];
    }

    private void initialize() {
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = -1;
            ++i;
        }
    }

    public int peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.list[this.size - 1];
    }

    public int pop() {
        int value = this.peek();
        this.list[this.size - 1] = -1;
        --this.size;
        return value;
    }

    public int push(int newValue) {
        if (this.size == this.list.length) {
            throw new StackFullException(newValue);
        }
        this.list[this.size++] = newValue;
        return newValue;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(String.valueOf(this.getClass().getName()) + ":" + this.size + " [");
        int i = 0;
        while (i < this.size) {
            s.append(this.list[i]);
            if (i < this.size - 1) {
                s.append(", ");
            }
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    public class StackFullException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StackFullException(int value) {
            super("Tried to push " + value + " on to a full stack[" + IntStack.this.list.length + "].");
        }
    }
}

