/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import org.eclipse.n4js.ui.navigator.internal.NodeAdapter;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.graphics.Image;

class NamedNode
extends NodeAdapter {
    private Object[] children = new Object[0];
    private final String label;
    private final Image image;

    NamedNode(Object parent, String label) {
        this(parent, label, null);
    }

    NamedNode(Object parent, String label, Image image) {
        super(parent);
        this.label = (String)Preconditions.checkNotNull((Object)label, (Object)"label");
        this.image = image;
    }

    @Override
    public Object[] getChildren() {
        return this.children;
    }

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.children);
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamedNode)) {
            return false;
        }
        NamedNode other = (NamedNode)obj;
        if (!Arrays.equals(this.children, other.children)) {
            return false;
        }
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }

    void addChild(Object ... child) {
        this.children = Arrays2.add((Object[])this.children, (Object[])child);
    }

    void addChild(Iterable<Object> children) {
        this.addChild(FluentIterable.from(children).toArray(Object.class));
    }
}

