/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.BreakStatement;
import org.eclipse.n4js.n4JS.ContinueStatement;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.Statement;

public class ASTUtils {
    public static String getNodeDetailString(Node node) {
        ControlFlowElement nCFE = node.getControlFlowElement();
        String edgeStr = String.valueOf(FGUtils.getClassName((EObject)nCFE)) + ":" + node.name + ":" + FGUtils.getSourceText((EObject)nCFE);
        return edgeStr;
    }

    public static LabelledStatement getLabelledStatement(Statement stmt) {
        if (stmt instanceof LabelledStatement) {
            return (LabelledStatement)stmt;
        }
        if (stmt instanceof BreakStatement) {
            return ((BreakStatement)stmt).getLabel();
        }
        if (stmt instanceof ContinueStatement) {
            return ((ContinueStatement)stmt).getLabel();
        }
        EObject container = stmt.eContainer();
        if (container instanceof LabelledStatement) {
            LabelledStatement lblStmt = (LabelledStatement)container;
            return lblStmt;
        }
        return null;
    }

    public static Expression unwrapParentheses(Expression parenExpr) {
        if (!(parenExpr instanceof ParenExpression)) {
            return parenExpr;
        }
        ParenExpression pe = (ParenExpression)parenExpr;
        return ASTUtils.unwrapParentheses(pe.getExpression());
    }
}

