/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class LaunchConfigurationMainTab
extends AbstractLaunchConfigurationTab {
    private static final String MAIN_TAB_NAME = "Main";
    private Text fileText;
    private Button fileButton;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = LaunchConfigurationMainTab.createComposite(parent, font, 1, 1, 1808);
        this.createFileGroup(comp);
        this.setControl((Control)comp);
    }

    private void createFileGroup(Composite parent) {
        Group fileGroup = new Group(parent, 0);
        fileGroup.setText("File");
        GridData gd = new GridData(768);
        fileGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        fileGroup.setLayout((Layout)layout);
        fileGroup.setFont(parent.getFont());
        this.fileText = new Text((Composite)fileGroup, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.setFont(parent.getFont());
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fileButton = this.createPushButton((Composite)fileGroup, "Search...", null);
        gd = new GridData(768);
        this.fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchConfigurationMainTab.this.browseFiles();
            }
        });
    }

    protected void browseFiles() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(this.getShell(), (IContainer)root, 1);
        dialog.setTitle("Search File");
        if (dialog.open() == 0) {
            Object[] files = dialog.getResult();
            IFile file = (IFile)files[0];
            this.fileText.setText(file.getFullPath().toString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String path = null;
            path = configuration.getAttribute("XT_FILE_TO_RUN", "");
            if (path != null) {
                this.fileText.setText(path);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String file = this.fileText.getText().trim();
        if (file.length() == 0) {
            file = null;
        }
        configuration.setAttribute("XT_FILE_TO_RUN", file);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public String getName() {
        return MAIN_TAB_NAME;
    }
}

