/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.log4j.Logger;

public class N4jscJarProvider {
    private static final Logger LOGGER = Logger.getLogger(N4jscJarProvider.class);
    public static final String PROVIDED_N4JSC_JAR_ENV = "PROVIDED_N4JSC_JAR";
    public static final String DEFAULT_N4JSC_JAR = "target/n4jsc.jar";

    public static File getAbsoluteRunnableN4jsc() {
        File jar;
        String providedJar = System.getenv(PROVIDED_N4JSC_JAR_ENV);
        if (providedJar == null || "".equals(providedJar.trim()) || "null".equals(providedJar)) {
            LOGGER.info((Object)"Environment variable \"PROVIDED_N4JSC_JAR\" is unset; using default \"target/n4jsc.jar\"");
            jar = new File(DEFAULT_N4JSC_JAR).getAbsoluteFile();
        } else {
            LOGGER.info((Object)("Environment variable \"PROVIDED_N4JSC_JAR\" is set to: " + providedJar));
            jar = new File(providedJar).getAbsoluteFile();
        }
        LOGGER.info((Object)("Using n4jsc.jar at: " + jar.getAbsolutePath()));
        Preconditions.checkState((boolean)jar.exists(), (Object)("n4jsc.jar does not exist at location: " + jar));
        return jar;
    }
}

