/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.n4idl.assistants;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.EqualityOperator;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4idl.migrations.AndSwitchCondition;
import org.eclipse.n4js.n4idl.migrations.ArrayTypeSwitchCondition;
import org.eclipse.n4js.n4idl.migrations.ConstantSwitchCondition;
import org.eclipse.n4js.n4idl.migrations.OrSwitchCondition;
import org.eclipse.n4js.n4idl.migrations.SwitchCondition;
import org.eclipse.n4js.n4idl.migrations.TypeSwitchCondition;
import org.eclipse.n4js.n4idl.migrations.TypeTypeCondition;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TypeSwitchTranspiler
extends TransformationAssistant {
    public List<Expression> transform(SwitchCondition condition, Expression lhs) {
        Functions.Function1 _function = e -> TranspilerBuilderBlocks._Parenthesis((Expression)e);
        return ListExtensions.map(this.doTransform(condition, (Expression)this.copy((EObject)lhs)), (Functions.Function1)_function);
    }

    private List<Expression> _doTransform(OrSwitchCondition or, Expression lhs) {
        Functions.Function1 _function = op -> this.transform((SwitchCondition)op, lhs);
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)or.operands, (Functions.Function1)_function)));
    }

    private List<Expression> _doTransform(AndSwitchCondition and, Expression lhs) {
        Functions.Function1 _function = op -> this.transform((SwitchCondition)op, lhs);
        Functions.Function1 _function_1 = subExpressions -> TranspilerBuilderBlocks._AND((Iterable)subExpressions);
        return ListExtensions.map((List)ListExtensions.map((List)and.operands, (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    private List<Expression> _doTransform(ArrayTypeSwitchCondition arrayCondition, Expression lhs) {
        ParameterizedPropertyAccessExpression_IM arrayIsArray = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.getSymbolTableEntryInternal("Array", true)), (SymbolTableEntry[])new SymbolTableEntry[]{this.getSymbolTableEntryInternal("isArray", true)});
        ParameterizedCallExpression isArrayExpression = TranspilerBuilderBlocks._CallExpr((Expression)arrayIsArray, (Expression[])new Expression[]{(Expression)this.copy((EObject)lhs)});
        RelationalExpression notEmptyExpression = TranspilerBuilderBlocks._RelationalExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)((Expression)this.copy((EObject)lhs)), (SymbolTableEntry[])new SymbolTableEntry[]{this.getSymbolTableEntryInternal("length", true)}), (RelationalOperator)RelationalOperator.GT, (Expression)TranspilerBuilderBlocks._NumericLiteral((int)0));
        List<Expression> elementTypeExpression = this.transform(arrayCondition.elementTypeCondition, (Expression)TranspilerBuilderBlocks._IndexAccessExpr((Expression)((Expression)this.copy((EObject)lhs)), (Expression)TranspilerBuilderBlocks._NumericLiteral((int)0)));
        Iterable _plus = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{isArrayExpression, notEmptyExpression})), elementTypeExpression);
        Expression __AND = TranspilerBuilderBlocks._AND((Iterable)_plus);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{__AND}));
    }

    private List<Expression> _doTransform(TypeTypeCondition typeTypeCondition, Expression lhs) {
        ParameterizedPropertyAccessExpression_IM __PropertyAccessExpr = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)lhs, (SymbolTableEntry[])new SymbolTableEntry[]{this.getSymbolTableEntryInternal("n4type", true)});
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{__PropertyAccessExpr}));
    }

    private List<Expression> _doTransform(TypeSwitchCondition typeCondition, Expression lhs) {
        Expression _runtimeTypeCheck = this.runtimeTypeCheck(typeCondition.type, lhs);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{_runtimeTypeCheck}));
    }

    private Expression _runtimeTypeCheck(TClassifier type, Expression lhs) {
        SymbolTableEntryOriginal typeSTE = (SymbolTableEntryOriginal)this.getState().steCache.mapOriginal.get(type);
        return TranspilerBuilderBlocks._RelationalExpr((Expression)lhs, (RelationalOperator)RelationalOperator.INSTANCEOF, (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)typeSTE));
    }

    private Expression _runtimeTypeCheck(PrimitiveType type, Expression lhs) {
        BooleanLiteral _switchResult;
        block21: {
            block19: {
                _switchResult = null;
                String _name = type.getName();
                if (_name == null) break block19;
                switch (_name) {
                    case "any": {
                        _switchResult = TranspilerBuilderBlocks._TRUE();
                        break block21;
                    }
                    case "int": {
                        _switchResult = this._TypeOfCheck(lhs, "number");
                        break block21;
                    }
                    case "number": {
                        _switchResult = this._TypeOfCheck(lhs, "number");
                        break block21;
                    }
                    case "string": {
                        _switchResult = this._TypeOfCheck(lhs, "string");
                        break block21;
                    }
                    case "boolean": {
                        _switchResult = this._TypeOfCheck(lhs, "boolean");
                        break block21;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled primitive type in TypeSwitchTranspiler: " + type);
                    }
                }
            }
            throw new IllegalStateException("Unhandled primitive type in TypeSwitchTranspiler: " + type);
        }
        return _switchResult;
    }

    private Expression _runtimeTypeCheck(Type type, Expression lhs) {
        throw new IllegalStateException("Cannot produce runtime type-check for type " + type);
    }

    private Expression _TypeOfCheck(Expression lhs, String typeofResult) {
        return TranspilerBuilderBlocks._EqualityExpr((Expression)TranspilerBuilderBlocks._UnaryExpr((UnaryOperator)UnaryOperator.TYPEOF, (Expression)lhs), (EqualityOperator)EqualityOperator.SAME, (Expression)TranspilerBuilderBlocks._StringLiteral((String)typeofResult));
    }

    private List<Expression> _doTransform(ConstantSwitchCondition constantCondition, Expression lhs) {
        boolean _equals = constantCondition.constant.equals("true");
        if (_equals) {
            BooleanLiteral __TRUE = TranspilerBuilderBlocks._TRUE();
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{__TRUE}));
        }
        boolean _equals_1 = constantCondition.constant.equals("true");
        if (_equals_1) {
            BooleanLiteral __FALSE = TranspilerBuilderBlocks._FALSE();
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{__FALSE}));
        }
        throw new IllegalStateException("Unhandled ConstantSwitchCondition with constant '" + constantCondition.constant + "'");
    }

    private List<Expression> _doTransform(SwitchCondition unhandledCondition, Expression lhs) {
        String _simpleName = unhandledCondition.getClass().getSimpleName();
        String _plus = "Encountered unhandled switch-condition of type " + _simpleName;
        String _plus_1 = String.valueOf(_plus) + " in transpiler: ";
        String _string = unhandledCondition.toString();
        String _plus_2 = String.valueOf(_plus_1) + _string;
        throw new IllegalStateException(_plus_2);
    }

    private List<Expression> doTransform(SwitchCondition and, Expression lhs) {
        if (and instanceof AndSwitchCondition) {
            return this._doTransform((AndSwitchCondition)and, lhs);
        }
        if (and instanceof ArrayTypeSwitchCondition) {
            return this._doTransform((ArrayTypeSwitchCondition)and, lhs);
        }
        if (and instanceof ConstantSwitchCondition) {
            return this._doTransform((ConstantSwitchCondition)and, lhs);
        }
        if (and instanceof OrSwitchCondition) {
            return this._doTransform((OrSwitchCondition)and, lhs);
        }
        if (and instanceof TypeSwitchCondition) {
            return this._doTransform((TypeSwitchCondition)and, lhs);
        }
        if (and instanceof TypeTypeCondition) {
            return this._doTransform((TypeTypeCondition)and, lhs);
        }
        if (and != null) {
            return this._doTransform(and, lhs);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(and, lhs).toString());
    }

    private Expression runtimeTypeCheck(Type type, Expression lhs) {
        if (type instanceof PrimitiveType) {
            return this._runtimeTypeCheck((PrimitiveType)type, lhs);
        }
        if (type instanceof TClassifier) {
            return this._runtimeTypeCheck((TClassifier)type, lhs);
        }
        if (type != null) {
            return this._runtimeTypeCheck(type, lhs);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, lhs).toString());
    }
}

