/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.codeActions.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class ChangeProvider {
    public static TextEdit replace(int startLine, int startChar, int endLine, int endChar, String replacementText) {
        Position posStart = new Position(startLine, startChar);
        Position posEnd = new Position(endLine, endChar);
        Range range = new Range(posStart, posEnd);
        return new TextEdit(range, replacementText);
    }

    public static TextEdit replace(Document doc, int offset, int length, String replacementText) {
        Position posStart = doc.getPosition(offset);
        Position posEnd = doc.getPosition(offset + length);
        Range range = new Range(posStart, posEnd);
        return new TextEdit(range, replacementText);
    }

    public static TextEdit insertLineAbove(Document doc, int offset, String txt, boolean sameIndentation) {
        Position offsetPos = doc.getPosition(offset);
        String NL = ChangeProvider.lineDelimiter(doc, offset);
        String replacementText = String.valueOf(txt) + NL;
        if (sameIndentation) {
            String lineContent = doc.getLineContent(offsetPos.getLine());
            int idx = 0;
            while (idx < lineContent.length() && Character.isWhitespace(lineContent.charAt(idx))) {
                ++idx;
            }
            String indent = lineContent.substring(0, idx);
            replacementText = String.valueOf(indent) + replacementText;
        }
        Position posStart = doc.getPosition(offsetPos.getLine());
        Position posEnd = doc.getPosition(offsetPos.getLine());
        Range range = new Range(posStart, posEnd);
        return new TextEdit(range, replacementText);
    }

    public static String lineDelimiter(Document doc, int offset) {
        String lineBreakString;
        if (doc.getLineCount() < 1) {
            return "\n";
        }
        Position offsetPos = doc.getPosition(offset);
        int lineN0 = offsetPos.getLine();
        if (offsetPos.getLine() > 0) {
            --lineN0;
        }
        int lineN1 = lineN0 + 1;
        int offsetAtStart = doc.getOffSet(new Position(lineN1, 0));
        Position posStart = doc.getPosition(offsetAtStart - 2);
        Position posEnd = doc.getPosition(offsetAtStart);
        Range range = new Range(posStart, posEnd);
        switch (lineBreakString = doc.getSubstring(range)) {
            case "\r\n": {
                return "\r\n";
            }
            case "\n": {
                return "\n";
            }
        }
        return "\n";
    }

    public static TextEdit removeSemanticObject(Document doc, EObject obj, boolean removeEntireLineIfEmpty) {
        if (obj == null) {
            return null;
        }
        return ChangeProvider.removeNode(doc, (INode)NodeModelUtils.findActualNodeFor((EObject)obj), removeEntireLineIfEmpty);
    }

    public static TextEdit removeNode(Document doc, INode node, boolean removeEntireLineIfEmpty) {
        if (node == null) {
            return null;
        }
        return ChangeProvider.removeText(doc, node.getOffset(), node.getLength(), removeEntireLineIfEmpty);
    }

    public static TextEdit removeText(Document doc, int offset, int length, boolean removeEntireLineIfEmpty) {
        Position posStart = doc.getPosition(offset);
        Position posEnd = doc.getPosition(offset + length);
        if (removeEntireLineIfEmpty) {
            int startLine = posStart.getLine();
            int endLine = posEnd.getLine();
            String startLineContent = doc.getLineContent(startLine);
            String endLineContent = startLine != endLine ? doc.getLineContent(endLine) : startLineContent;
            startLineContent = startLineContent.substring(0, posStart.getCharacter());
            endLineContent = endLineContent.substring(posEnd.getCharacter());
            String resultLineContent = String.valueOf(startLineContent) + endLineContent;
            if (resultLineContent.isBlank()) {
                posStart = new Position(posStart.getLine(), 0);
                posEnd = new Position(posEnd.getLine() + 1, 0);
            }
        }
        Range range = new Range(posStart, posEnd);
        return new TextEdit(range, "");
    }

    public static TextEdit deleteLine(Document doc, int offset, boolean deleteOnlyIfEmpty) {
        Position offPosition = doc.getPosition(offset);
        String lineContent = doc.getLineContent(offPosition.getLine());
        if (deleteOnlyIfEmpty && !lineContent.isBlank()) {
            return null;
        }
        Position posStart = new Position(offPosition.getLine(), 0);
        Position posEnd = new Position(offPosition.getLine() + 1, 0);
        Range range = new Range(posStart, posEnd);
        return new TextEdit(range, "");
    }
}

