/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.inject.Inject;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.resource.N4JSUnloader;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilder;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IDerivedStateComputer;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class N4JSDerivedStateComputer
implements IDerivedStateComputer {
    @Inject
    @Extension
    private N4JSUnloader _n4JSUnloader;
    @Inject
    private N4JSTypesBuilder typesBuilder;

    public void installDerivedState(DerivedStateAwareResource resource, boolean preLinkingPhase) {
        boolean _equals;
        EList contents = resource.getContents();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)contents);
        if (_isNullOrEmpty) {
            String _string = resource.getURI().toString();
            String _plus = "cannot install derived state in resource '" + _string;
            String msg = String.valueOf(_plus) + "' without AST";
            throw new IllegalStateException(msg);
        }
        int _size = contents.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            this.typesBuilder.createTModuleFromSource(resource, preLinkingPhase);
        } else {
            boolean _equals_1;
            int _size_1 = contents.size();
            boolean bl2 = _equals_1 = _size_1 == 2;
            if (_equals_1) {
                this.typesBuilder.relinkTModuleToSource(resource, preLinkingPhase);
            } else {
                String _string_1 = resource.getURI().toString();
                String _plus_1 = "resource '" + _string_1;
                String _plus_2 = String.valueOf(_plus_1) + "' with more than two roots";
                throw new IllegalStateException(_plus_2);
            }
        }
    }

    public void discardDerivedState(DerivedStateAwareResource resource) {
        EList contents = resource.getContents();
        boolean _isEmpty = contents.isEmpty();
        if (_isEmpty) {
            return;
        }
        List tail = contents.subList(1, contents.size());
        Consumer<EObject> _function = it -> this._n4JSUnloader.unloadRoot((EObject)it);
        tail.forEach(_function);
        tail.clear();
    }
}

