/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.base.Stopwatch;
import com.google.inject.Injector;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.n4js.binaries.nodejs.JavaBinary;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.binaries.nodejs.YarnBinary;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.helper.CliTools;
import org.eclipse.n4js.cli.helper.ProcessResult;
import org.eclipse.n4js.cli.helper.TestProcessBuilder;

public class TestProcessExecuter {
    private final TestProcessBuilder testProcessBuilder;

    public TestProcessExecuter(Injector injector) {
        NodeJsBinary nodeJsBinary = (NodeJsBinary)injector.getInstance(NodeJsBinary.class);
        NpmBinary npmBinary = (NpmBinary)injector.getInstance(NpmBinary.class);
        YarnBinary yarnBinary = (YarnBinary)injector.getInstance(YarnBinary.class);
        JavaBinary javaBinary = (JavaBinary)injector.getInstance(JavaBinary.class);
        this.testProcessBuilder = new TestProcessBuilder(nodeJsBinary, npmBinary, yarnBinary, javaBinary);
    }

    public ProcessResult runNodejs(Path workingDir, Map<String, String> environment, Path runFile, String ... options) {
        return this.joinProcess(() -> this.testProcessBuilder.nodejsRun(workingDir, environment, runFile, options));
    }

    public ProcessResult npmRun(Path workingDir, Map<String, String> environment, String ... options) {
        return this.joinProcess(() -> this.testProcessBuilder.npmRun(workingDir, environment, options));
    }

    public ProcessResult yarnRun(Path workingDir, Map<String, String> environment, String ... options) {
        return this.joinProcess(() -> this.testProcessBuilder.yarnRun(workingDir, environment, options));
    }

    public ProcessResult n4jscRun(Path workingDir, Map<String, String> environment, N4jscOptions options) {
        return this.joinProcess(() -> this.testProcessBuilder.n4jscRun(workingDir, environment, options));
    }

    private ProcessResult joinProcess(Supplier<ProcessBuilder> pbs) {
        ProcessBuilder processBuilder = pbs.get();
        File workingDir = processBuilder.directory();
        ProcessResult result = new ProcessResult();
        result.command = String.join((CharSequence)" ", processBuilder.command());
        result.workingDir = workingDir.toString();
        Stopwatch sw = Stopwatch.createStarted();
        try {
            try {
                Process process = processBuilder.start();
                result.exitCode = process.waitFor();
                result.stdOut = this.getInputAsString(process.getInputStream());
                result.errOut = this.getInputAsString(process.getErrorStream());
            }
            catch (Exception e) {
                result.exception = e;
                if (result.exitCode == Integer.MIN_VALUE) {
                    result.exitCode = -1;
                }
                result.duration = sw.stop().elapsed(TimeUnit.MILLISECONDS);
                CliTools.trimOutputs(result, false);
            }
        }
        finally {
            result.duration = sw.stop().elapsed(TimeUnit.MILLISECONDS);
            CliTools.trimOutputs(result, false);
        }
        return result;
    }

    private String getInputAsString(InputStream is) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(is);){
            String string = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
            return string.trim();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static interface ProcessSupplier {
        public Process get() throws ExecutionException;
    }
}

