/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.editor.contentassist.imports;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.ide.editor.contentassist.imports.ImportRewriter;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.scoping.IContentAssistScopeProvider;
import org.eclipse.n4js.scoping.imports.PlainAccessOfAliasedImportDescription;
import org.eclipse.n4js.scoping.imports.PlainAccessOfNamespacedImportDescription;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalCreator;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.Arrays;
import org.eclipse.xtext.util.ReplaceRegion;

public class ImportsAwareReferenceProposalCreator {
    @Inject
    private IScopeProvider scopeProvider;
    private IValueConverter<String> valueConverter;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ImportRewriter importRewriter;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    private static final EReference[] referencesSupportingImportedElements = new EReference[]{N4JSPackage.Literals.IDENTIFIER_REF__ID, TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE};

    @Inject
    private void setValueConverter(IValueConverterService service, N4JSGrammarAccess grammarAccess) {
        IValueConverter converter;
        this.valueConverter = converter = ((IValueConverterService.Introspectable)service).getConverter(grammarAccess.getTypeReferenceNameRule().getName());
    }

    public void lookupCrossReference(EObject model, EReference reference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor, Predicate<IEObjectDescription> filter, IdeContentProposalCreator proposalFactory) {
        if (model != null) {
            IContentAssistScopeProvider contentAssistScopeProvider = (IContentAssistScopeProvider)this.scopeProvider;
            IScope scope = contentAssistScopeProvider.getScopeForContentAssist(model, reference);
            Iterable candidates = scope.getAllElements();
            for (IEObjectDescription candidate : candidates) {
                if (!acceptor.canAcceptMoreProposals()) {
                    return;
                }
                if (!filter.apply((Object)candidate)) continue;
                QualifiedName qfn = candidate.getQualifiedName();
                int qfnSegmentCount = qfn.getSegmentCount();
                String tmodule = qfnSegmentCount >= 2 ? qfn.getSegment(qfnSegmentCount - 2) : null;
                ContentAssistEntry proposal = this.getProposal(candidate, model, scope, reference, context, filter, proposalFactory);
                acceptor.accept(proposal, 0);
            }
        }
    }

    private ContentAssistEntry getProposal(IEObjectDescription candidate, EObject model, IScope scope, EReference reference, ContentAssistContext context, Predicate<IEObjectDescription> filter, IdeContentProposalCreator delegateProposalFactory) {
        Resource resource = model.eResource();
        IEObjectDescription inputToUse = this.getAliasedDescription(candidate, reference, context);
        QualifiedName name = inputToUse.getName();
        String shortQName = N4JSLanguageUtils.lastSegmentOrDefaultHost((QualifiedName)name);
        ContentAssistEntry result = delegateProposalFactory.createProposal(name.toString(), context);
        if (result != null) {
            int version = N4JSResourceDescriptionStrategy.getVersion((IEObjectDescription)inputToUse);
            QualifiedName qName = inputToUse.getQualifiedName();
            if (qName.equals((Object)name)) {
                EObject eObj = inputToUse.getEObjectOrProxy();
                QualifiedName qnOfEObject = this.qualifiedNameProvider.getFullyQualifiedName(eObj);
                qName = qnOfEObject != null ? qnOfEObject : qName;
            }
            String description = this.getDescription(qName, name, version);
            String label = this.getLabel(qName, name, version);
            String kind = this.getKind(candidate);
            result.setLabel(label);
            result.setDescription(description);
            result.setKind(kind);
            Collection<ReplaceRegion> regions = this.getImportChanges(name.toString(), resource, scope, candidate, filter);
            if (regions != null && !regions.isEmpty()) {
                result.getTextReplacements().addAll(regions);
            }
        }
        return result;
    }

    String getDescription(QualifiedName qualifiedName, QualifiedName shortName, int version) {
        String result = "";
        if (qualifiedName.getSegmentCount() > 1) {
            String lastSegment = qualifiedName.getLastSegment();
            String shortNameString = shortName.toString();
            String typeVersion = version == 0 ? "" : "#" + String.valueOf(version);
            result = shortNameString.endsWith(lastSegment) ? this.qualifiedNameConverter.toString(qualifiedName.skipLast(1)) : "alias for " + lastSegment;
            result = String.valueOf(result) + typeVersion;
        }
        return result;
    }

    String getLabel(QualifiedName qualifiedName, QualifiedName shortName, int version) {
        String shortNameString;
        String result = shortNameString = shortName.toString();
        if (qualifiedName.getSegmentCount() > 1) {
            String lastSegment = qualifiedName.getLastSegment();
            if (shortNameString.endsWith(lastSegment)) {
                String typeVersion = version == 0 ? "" : "#" + String.valueOf(version);
                result = String.valueOf(lastSegment) + typeVersion;
            } else {
                result = shortNameString;
            }
        }
        return result;
    }

    private String getKind(IEObjectDescription candidate) {
        EClass eClass = candidate.getEClass();
        String kind = "TEXT";
        if (TypesPackage.eINSTANCE.getTClass() == eClass) {
            kind = "CLASS";
        }
        if (TypesPackage.eINSTANCE.getTInterface() == eClass) {
            kind = "INTERFACE";
        }
        if (TypesPackage.eINSTANCE.getTEnum() == eClass) {
            kind = "ENUM";
        }
        if (TypesPackage.eINSTANCE.getTFunction() == eClass) {
            kind = "FUNCTION";
        }
        if (TypesPackage.eINSTANCE.getTVariable() == eClass) {
            kind = "VARIABLE";
        }
        return kind;
    }

    private IEObjectDescription getAliasedDescription(IEObjectDescription candidate, EReference reference, ContentAssistContext context) {
        QualifiedName inputQN = candidate.getName();
        int inputNameSegmentCount = inputQN.getSegmentCount();
        if (inputNameSegmentCount > 1 && Arrays.contains((Object[])referencesSupportingImportedElements, (Object)reference)) {
            return new AliasedEObjectDescription(QualifiedName.create((String)inputQN.getLastSegment()), candidate);
        }
        if (inputNameSegmentCount == 2 && N4TSQualifiedNameProvider.GLOBAL_NAMESPACE_SEGMENT.equals(inputQN.getFirstSegment())) {
            return new AliasedEObjectDescription(QualifiedName.create((String)inputQN.getLastSegment()), candidate);
        }
        if (inputQN.getLastSegment().equals("default")) {
            if (TExportableElement.class.isAssignableFrom(candidate.getEClass().getInstanceClass()) && N4JSResourceDescriptionStrategy.getExportDefault((IEObjectDescription)candidate)) {
                return new AliasedEObjectDescription(inputQN, candidate);
            }
            QualifiedName nameNoDefault = inputQN.skipLast(1);
            QualifiedName moduleName = nameNoDefault.getSegmentCount() > 1 ? QualifiedName.create((String)nameNoDefault.getLastSegment()) : nameNoDefault;
            return new AliasedEObjectDescription(moduleName, candidate);
        }
        return candidate;
    }

    private Collection<ReplaceRegion> getImportChanges(String syntacticReplacementString, Resource resource, IScope scope, IEObjectDescription candidate, Predicate<IEObjectDescription> filter) {
        QualifiedName shortQualifiedName;
        String actualSyntacticReplacementString = this.getActualReplacementString(syntacticReplacementString, scope, resource, filter);
        if (!syntacticReplacementString.equals(actualSyntacticReplacementString) && (shortQualifiedName = this.applyValueConverter(actualSyntacticReplacementString)).getSegmentCount() == 1) {
            return Collections.emptyList();
        }
        QualifiedName qualifiedName = this.getCandidateName(candidate);
        QualifiedName originalQualifiedName = candidate.getQualifiedName();
        if (qualifiedName == null) {
            return Collections.emptyList();
        }
        if (qualifiedName.getSegmentCount() == 1) {
            return Collections.emptyList();
        }
        if (qualifiedName.getSegmentCount() == 2 && N4TSQualifiedNameProvider.GLOBAL_NAMESPACE_SEGMENT.equals(qualifiedName.getFirstSegment())) {
            return Collections.emptyList();
        }
        String alias = null;
        String shortQName = N4JSLanguageUtils.lastSegmentOrDefaultHost((QualifiedName)originalQualifiedName);
        IEObjectDescription descriptionFullQN = scope.getSingleElement(QualifiedName.create((String)shortQName));
        if (descriptionFullQN instanceof PlainAccessOfNamespacedImportDescription) {
            return Collections.emptyList();
        }
        if (descriptionFullQN instanceof PlainAccessOfAliasedImportDescription) {
            return Collections.emptyList();
        }
        if (descriptionFullQN != null) {
            if (descriptionFullQN.getEObjectOrProxy() instanceof ModuleNamespaceVirtualType) {
                return Collections.emptyList();
            }
            alias = "Alias" + UtilN4.toUpperCaseFirst((String)shortQName);
        }
        ImportRewriter.ImportChanges importChanges = this.importRewriter.create("\n", resource);
        importChanges.addImport(qualifiedName, alias);
        Collection<ReplaceRegion> regions = importChanges.toReplaceRegions();
        return regions;
    }

    private QualifiedName getCandidateName(IEObjectDescription candidate) {
        QualifiedName candidateName;
        QualifiedName qfn = candidate.getQualifiedName();
        int qfnSegmentCount = qfn.getSegmentCount();
        String tmodule = qfnSegmentCount >= 2 ? qfn.getSegment(qfnSegmentCount - 2) : null;
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(candidate.getEObjectURI()).orNull();
        if (project != null && tmodule != null && tmodule.equals(project.getMainModule())) {
            N4JSProjectName projectName = project.getProjectName();
            N4JSProjectName definesPackage = project.getDefinesPackageName();
            if (definesPackage != null) {
                projectName = definesPackage;
            }
            String lastSegmentOfQFN = candidate.getQualifiedName().getLastSegment().toString();
            candidateName = QualifiedName.create((String[])new String[]{projectName.getRawName(), lastSegmentOfQFN});
        } else {
            candidateName = candidate.getQualifiedName();
        }
        return candidateName;
    }

    private String applyValueConverter(QualifiedName qualifiedName) {
        String result = this.qualifiedNameConverter.toString(qualifiedName);
        result = this.valueConverter.toString((Object)result);
        return result;
    }

    private QualifiedName applyValueConverter(String concreteSyntax) {
        String semanticReplacementString = (String)this.valueConverter.toValue(concreteSyntax, null);
        QualifiedName qualifiedName = this.qualifiedNameConverter.toQualifiedName(semanticReplacementString);
        return qualifiedName;
    }

    public String getActualReplacementString(String syntacticReplacementString, IScope scope, Resource resource, Predicate<IEObjectDescription> filter) {
        if (scope != null) {
            IEObjectDescription description;
            EObject resolved;
            QualifiedName qualifiedName = this.applyValueConverter(syntacticReplacementString);
            if (qualifiedName.getSegmentCount() == 1) {
                return syntacticReplacementString;
            }
            IEObjectDescription element = scope.getSingleElement(qualifiedName);
            if (element != null && !(resolved = EcoreUtil.resolve((EObject)element.getEObjectOrProxy(), (Resource)resource)).eIsProxy() && (description = this.findApplicableDescription(resolved, qualifiedName, true, scope, filter)) != null) {
                String multisegmentProposal = this.applyValueConverter(description.getName());
                return multisegmentProposal;
            }
        }
        return syntacticReplacementString;
    }

    private IEObjectDescription findApplicableDescription(EObject objectOrProxy, QualifiedName qualifiedName, boolean simpleNameMatch, IScope scope, Predicate<IEObjectDescription> filter) {
        Iterable lookupElements = scope.getElements(objectOrProxy);
        for (IEObjectDescription lookupElement : lookupElements) {
            if (!filter.apply((Object)lookupElement) || simpleNameMatch != qualifiedName.getLastSegment().equals(lookupElement.getName().getLastSegment())) continue;
            return lookupElement;
        }
        return null;
    }
}

