/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.codeActions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.n4js.ide.server.codeActions.N4JSQuickfixProvider;

public class CodeActionAcceptor {
    List<Either<Command, CodeAction>> codeActions = new ArrayList<Either<Command, CodeAction>>();

    public void acceptQuickfixCommand(N4JSQuickfixProvider.QuickfixContext context, String title, String commandID, Object ... arguments) {
        this.acceptQuickfixCommand(context, title, commandID, Arrays.asList(arguments));
    }

    public void acceptQuickfixCommand(N4JSQuickfixProvider.QuickfixContext context, String title, String commandID, List<Object> arguments) {
        Command command = new Command();
        command.setTitle(title);
        command.setCommand(commandID);
        command.setArguments(arguments);
        this.acceptQuickfixCodeAction(context, title, command);
    }

    public void acceptQuickfixCodeAction(N4JSQuickfixProvider.QuickfixContext context, String title, Command command) {
        this.acceptQuickfixCodeAction(context, title, null, command);
    }

    public void acceptQuickfixCodeAction(N4JSQuickfixProvider.QuickfixContext context, String title, TextEdit ... textEdits) {
        if (textEdits == null) {
            return;
        }
        this.acceptQuickfixCodeAction(context, title, Arrays.asList(textEdits));
    }

    public void acceptQuickfixCodeAction(N4JSQuickfixProvider.QuickfixContext context, String title, List<TextEdit> textEdits) {
        if (textEdits == null || textEdits.isEmpty()) {
            return;
        }
        String uri = context.options.getCodeActionParams().getTextDocument().getUri();
        HashMap<String, List<TextEdit>> changes = new HashMap<String, List<TextEdit>>();
        changes.put(uri, textEdits);
        WorkspaceEdit edit = new WorkspaceEdit();
        edit.setChanges(changes);
        this.acceptQuickfixCodeAction(context, title, edit, null);
    }

    public void acceptQuickfixCodeAction(N4JSQuickfixProvider.QuickfixContext context, String title, WorkspaceEdit edit) {
        this.acceptQuickfixCodeAction(context, title, edit, null);
    }

    public void acceptQuickfixCodeAction(N4JSQuickfixProvider.QuickfixContext context, String title, WorkspaceEdit edit, Command command) {
        CodeActionContext cac;
        if (edit == null && command == null) {
            return;
        }
        CodeAction codeAction = new CodeAction();
        codeAction.setTitle(title);
        codeAction.setEdit(edit);
        codeAction.setCommand(command);
        codeAction.setKind("quickfix");
        if (context.options != null && context.options.getCodeActionParams() != null && (cac = context.options.getCodeActionParams().getContext()) != null && cac.getDiagnostics() != null) {
            codeAction.setDiagnostics(cac.getDiagnostics());
        }
        this.codeActions.add((Either<Command, CodeAction>)Either.forRight((Object)codeAction));
    }

    public List<Either<Command, CodeAction>> getList() {
        return this.codeActions;
    }
}

