/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.function.Consumer;
import org.eclipse.n4js.utils.AbstractNLSProcessor;
import org.eclipse.n4js.utils.NLS;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class NLSProcessor
extends AbstractNLSProcessor {
    private static List<String> SEVERITIES = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"error", "warning", "info", "ignore"}));

    @Override
    public Class<?> getAnnotationType() {
        return NLS.class;
    }

    @Override
    public void addMembers(MutableClassDeclaration annotatedClass, AnnotationReference nlsAnnotation, TransformationContext context, String propertyFileNameValue) {
        super.addMembers(annotatedClass, nlsAnnotation, context, propertyFileNameValue);
        this.addGetDefaultSeverityMethod(annotatedClass, nlsAnnotation, context);
    }

    @Override
    public void addGetStringMethod(final MutableClassDeclaration annotatedClass, AnnotationReference nlsAnnotation, final @Extension TransformationContext context) {
        String methodName = "getString";
        this.checkForExistentMethod(annotatedClass, "getString", context, nlsAnnotation, 1);
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(Visibility.PRIVATE);
            it.setStatic(true);
            it.setReturnType(context.getString());
            it.addParameter("key", context.getString());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"try {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    TypeReference _string = context.getString();
                    _builder.append((Object)_string, "\t");
                    _builder.append((Object)" value = ");
                    String _simpleName = annotatedClass.findDeclaredField("RESOURCE_BUNDLE").getSimpleName();
                    _builder.append((Object)_simpleName, "\t");
                    _builder.append((Object)".getString(key);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    TypeReference _string_1 = context.getString();
                    _builder.append((Object)_string_1, "\t");
                    _builder.append((Object)"[] parts = value.split(\";;;\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return parts[1];");
                    _builder.newLine();
                    _builder.append((Object)"} catch (");
                    _builder.append(MissingResourceException.class);
                    _builder.append((Object)" e) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return '!' + key + '!';");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod("getString", _function);
    }

    private void addGetDefaultSeverityMethod(final MutableClassDeclaration annotatedClass, AnnotationReference nlsAnnotation, final @Extension TransformationContext context) {
        String methodName = "getDefaultSeverity";
        this.checkForExistentMethod(annotatedClass, "getDefaultSeverity", context, nlsAnnotation, 1);
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(Visibility.PUBLIC);
            it.setStatic(true);
            it.setReturnType(context.newTypeReference(Severity.class, new TypeReference[0]));
            it.addParameter("key", context.getString());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"try {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    TypeReference _string = context.getString();
                    _builder.append((Object)_string, "\t");
                    _builder.append((Object)" value = ");
                    String _simpleName = annotatedClass.findDeclaredField("RESOURCE_BUNDLE").getSimpleName();
                    _builder.append((Object)_simpleName, "\t");
                    _builder.append((Object)".getString(key);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    TypeReference _string_1 = context.getString();
                    _builder.append((Object)_string_1, "\t");
                    _builder.append((Object)"[] parts = value.split(\";;;\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    TypeReference _string_2 = context.getString();
                    _builder.append((Object)_string_2, "\t");
                    _builder.append((Object)" defaultSeverity = parts[0];");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return ");
                    _builder.append(Severity.class, "\t");
                    _builder.append((Object)".valueOf(defaultSeverity.toUpperCase());");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"} catch (");
                    _builder.append(MissingResourceException.class);
                    _builder.append((Object)" e) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return null;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod("getDefaultSeverity", _function);
    }

    @Override
    public void addMethod(final Map.Entry<Object, Object> entry, MutableClassDeclaration annotatedClass, AnnotationReference nlsAnnotation, @Extension TransformationContext context) {
        boolean _not;
        boolean _notEquals;
        Object _value = entry.getValue();
        String value = (String)_value;
        String[] parts = value.split(";;;");
        int _length = parts.length;
        boolean bl = _notEquals = _length != 2;
        if (_notEquals) {
            Object _key = entry.getKey();
            String _plus = "Value for " + _key;
            String _plus_1 = String.valueOf(_plus) + " in properties file doesn't follow pattern 'defaultSeverity;;;message'";
            context.addError((Element)nlsAnnotation, _plus_1);
            return;
        }
        String defaultSeverity = parts[0];
        boolean _contains = SEVERITIES.contains(defaultSeverity);
        boolean bl2 = _not = !_contains;
        if (_not) {
            String _join = IterableExtensions.join(SEVERITIES, (CharSequence)", ");
            String _plus_2 = String.valueOf(defaultSeverity) + " is not a valid severity (which would be " + _join;
            String _plus_3 = String.valueOf(_plus_2) + ").";
            context.addError((Element)nlsAnnotation, _plus_3);
            return;
        }
        String message = parts[1];
        int wildcardCount = this.getWildcardCount(message);
        Iterable _xifexpression = null;
        if (wildcardCount > 0) {
            Functions.Function1 _function = it -> "param" + it;
            _xifexpression = IterableExtensions.map((Iterable)new IntegerRange(0, wildcardCount - 1), (Functions.Function1)_function);
        } else {
            _xifexpression = CollectionLiterals.newArrayList();
        }
        final ArrayList params = _xifexpression;
        Object _key_1 = entry.getKey();
        String getMessageForMethodName = "getMessageFor" + _key_1;
        this.checkForExistentMethod(annotatedClass, getMessageForMethodName, context, nlsAnnotation, IterableExtensions.size((Iterable)params));
        Procedures.Procedure1 _function_1 = it -> {
            it.setVisibility(Visibility.PUBLIC);
            it.setStatic(true);
            it.setReturnType(context.getString());
            Consumer<String> _function_2 = param -> it.addParameter(param, context.getObject());
            params.forEach(_function_2);
            it.setDocComment(message);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)"org.eclipse.osgi.util.NLS");
                    _builder.append((Object)".bind(getString(");
                    Object _key = entry.getKey();
                    _builder.append(_key);
                    _builder.append((Object)"), new Object [] { ");
                    String _join = IterableExtensions.join((Iterable)params, (CharSequence)", ");
                    _builder.append((Object)_join);
                    _builder.append((Object)" });");
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod(getMessageForMethodName, _function_1);
    }
}

