/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.discovery;

import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.epp.internal.mpc.ui.discovery.DiscoverFileSupportJob;
import org.eclipse.epp.internal.mpc.ui.discovery.ShowFileSupportProposalsDialog;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.IMarketplaceClientConfiguration;
import org.eclipse.epp.mpc.ui.IMarketplaceClientService;
import org.eclipse.epp.mpc.ui.MarketplaceClient;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.progress.UIJob;

final class ShowFileSupportProposalsJob
extends UIJob {
    private final Display display;
    private final IEditorRegistry editorRegistry;
    private final IEditorDescriptor defaultDescriptor;
    private final String fileName;
    private final List<? extends INode> nodes;

    ShowFileSupportProposalsJob(String fileName, List<? extends INode> nodes, IEditorRegistry editorRegistry, IEditorDescriptor defaultDescriptor, Display display) {
        super(Messages.AskMerketplaceForFileSupportStrategy_dialogJobName);
        this.fileName = fileName;
        this.nodes = nodes;
        this.editorRegistry = editorRegistry;
        this.defaultDescriptor = defaultDescriptor;
        this.display = display;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        String fileExtensionLabel;
        Shell shell = WorkbenchUtil.getShell();
        ShowFileSupportProposalsDialog dialog = new ShowFileSupportProposalsDialog(shell, fileExtensionLabel = DiscoverFileSupportJob.getFileExtensionLabel(this.fileName), this.defaultDescriptor);
        if (dialog.open() == 0) {
            if (dialog.isShowProposals()) {
                IMarketplaceClientService marketplaceClientService = MarketplaceClient.getMarketplaceClientService();
                IMarketplaceClientConfiguration config = marketplaceClientService.newConfiguration();
                marketplaceClientService.open(config, new LinkedHashSet<INode>(this.nodes));
            } else if (dialog.isAssociateToExtension()) {
                List<String> fileExtensions = DiscoverFileSupportJob.getFileExtensions(this.fileName);
                IFileEditorMapping newMapping = this.createDefaultDescriptorMapping(fileExtensions.get(fileExtensions.size() - 1));
                this.addEditorMapping(newMapping);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private void addEditorMapping(IFileEditorMapping newMapping) {
        FileEditorMapping[] mappings = new FileEditorMapping[this.editorRegistry.getFileEditorMappings().length + 1];
        System.arraycopy(this.editorRegistry.getFileEditorMappings(), 0, mappings, 0, mappings.length - 1);
        mappings[mappings.length - 1] = (FileEditorMapping)newMapping;
        ((EditorRegistry)this.editorRegistry).setFileEditorMappings(mappings);
        ((EditorRegistry)this.editorRegistry).saveAssociations();
    }

    private IFileEditorMapping createDefaultDescriptorMapping(String fileExtension) {
        FileEditorMapping newMapping = null;
        newMapping = this.fileName.equals(fileExtension) ? new FileEditorMapping(this.fileName, null) : new FileEditorMapping(fileExtension);
        newMapping.setDefaultEditor(this.defaultDescriptor);
        return newMapping;
    }

    public Display getDisplay() {
        if (this.display != null && !this.display.isDisposed()) {
            return this.display;
        }
        return super.getDisplay();
    }
}

