/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.node;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtext.generator.trace.AbstractStatefulTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IndentNode;
import org.eclipse.xtext.generator.trace.node.NewLineNode;
import org.eclipse.xtext.generator.trace.node.TextNode;
import org.eclipse.xtext.generator.trace.node.TraceNode;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class GeneratorNodeProcessor {
    public Result process(IGeneratorNode root) {
        Context ctx = new Context();
        this.doProcess(root, ctx);
        String _content = ctx.getContent();
        AbstractTraceRegion _currentRegion = ctx.getCurrentRegion();
        return new Result(_content, _currentRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _doProcess(IndentNode node, Context ctx) {
        boolean __hasContent = this._hasContent(node, ctx);
        if (__hasContent) {
            if (node.isIndentImmediately() && !ctx.isPendingIndent()) {
                ctx.appendToCurrentLine(node.getIndentationString());
            }
            try {
                ctx.increaseIndent(node);
                this.doProcessChildren(node, ctx);
            }
            finally {
                ctx.decreaseIndents();
            }
        }
    }

    protected void _doProcess(NewLineNode node, Context ctx) {
        if (node.isIfNotEmpty() && !GeneratorNodeProcessor.hasNonWhitespace(ctx.currentLineContent())) {
            ctx.resetCurrentLine();
        } else {
            boolean _isPendingIndent = ctx.isPendingIndent();
            if (_isPendingIndent) {
                this.handlePendingIndent(ctx, true);
            }
            ctx.appendToCurrentLine(node.getLineDelimiter());
            ctx.addNewLine();
        }
        ctx.setPendingIndent(true);
    }

    protected void _doProcess(TextNode node, Context ctx) {
        boolean __hasContent = this._hasContent(node, ctx);
        if (__hasContent) {
            boolean _isPendingIndent = ctx.isPendingIndent();
            if (_isPendingIndent) {
                this.handlePendingIndent(ctx, false);
            }
            ctx.appendToCurrentLine(node.getText());
        }
    }

    protected void handlePendingIndent(Context ctx, boolean endOfLine) {
        boolean _greaterThan;
        StringBuilder indentString = new StringBuilder();
        Deque<IndentNode> _currentIndents = ctx.getCurrentIndents();
        for (IndentNode indentNode : _currentIndents) {
            if (!indentNode.isIndentEmptyLines() && endOfLine) continue;
            indentString.append(indentNode.getIndentationString());
        }
        int _length = indentString.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            ctx.insertIntoCurrentLine(0, indentString);
        }
        ctx.setPendingIndent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _doProcess(TraceNode node, Context ctx) {
        boolean __hasContent = this._hasContent(node, ctx);
        if (__hasContent) {
            AbstractTraceRegion beforeRegion = ctx.getCurrentRegion();
            boolean _isUseForDebugging = node.isUseForDebugging();
            ILocationData _sourceLocation = node.getSourceLocation();
            CompletableTraceRegion newRegion = new CompletableTraceRegion(_isUseForDebugging, _sourceLocation, beforeRegion);
            int offset = ctx.contentLength();
            int startLineNumber = ctx.currentLineNumber();
            try {
                ctx.setCurrentRegion(newRegion);
                this.doProcessChildren(node, ctx);
            }
            finally {
                if (beforeRegion != null) {
                    ctx.setCurrentRegion(beforeRegion);
                }
                int _contentLength = ctx.contentLength();
                int _minus = _contentLength - offset;
                newRegion.complete(offset, _minus, startLineNumber, ctx.currentLineNumber());
            }
        }
    }

    protected void _doProcess(CompositeGeneratorNode node, Context ctx) {
        this.doProcessChildren(node, ctx);
    }

    protected void doProcessChildren(CompositeGeneratorNode node, Context ctx) {
        List<IGeneratorNode> _children = node.getChildren();
        for (IGeneratorNode child : _children) {
            this.doProcess(child, ctx);
        }
    }

    protected boolean _hasContent(CompositeGeneratorNode node, Context ctx) {
        Functions.Function1 _function = it -> this.hasContent((IGeneratorNode)it, ctx);
        return IterableExtensions.exists(node.getChildren(), (Functions.Function1)_function);
    }

    protected boolean _hasContent(NewLineNode node, Context ctx) {
        return !node.isIfNotEmpty() || ctx.currentLineContent().length() != 0;
    }

    protected boolean _hasContent(TextNode node, Context ctx) {
        boolean _isNullOrEmpty = GeneratorNodeProcessor.isNullOrEmpty(node.getText());
        return !_isNullOrEmpty;
    }

    protected static boolean hasNonWhitespace(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            boolean _not;
            boolean _isWhitespace = Character.isWhitespace(s.charAt(i));
            boolean bl = _not = !_isWhitespace;
            if (!_not) continue;
            return true;
        }
        return false;
    }

    protected static boolean isNullOrEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    protected void doProcess(IGeneratorNode node, Context ctx) {
        if (node instanceof IndentNode) {
            this._doProcess((IndentNode)node, ctx);
            return;
        }
        if (node instanceof TraceNode) {
            this._doProcess((TraceNode)node, ctx);
            return;
        }
        if (node instanceof CompositeGeneratorNode) {
            this._doProcess((CompositeGeneratorNode)node, ctx);
            return;
        }
        if (node instanceof NewLineNode) {
            this._doProcess((NewLineNode)node, ctx);
            return;
        }
        if (node instanceof TextNode) {
            this._doProcess((TextNode)node, ctx);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, ctx).toString());
    }

    protected boolean hasContent(IGeneratorNode node, Context ctx) {
        if (node instanceof CompositeGeneratorNode) {
            return this._hasContent((CompositeGeneratorNode)node, ctx);
        }
        if (node instanceof NewLineNode) {
            return this._hasContent((NewLineNode)node, ctx);
        }
        if (node instanceof TextNode) {
            return this._hasContent((TextNode)node, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, ctx).toString());
    }

    public static class CompletableTraceRegion
    extends AbstractStatefulTraceRegion {
        private CompletableTextRegion region;

        public CompletableTraceRegion(boolean useForDebugging, ILocationData associatedLocation, AbstractTraceRegion parent) {
            this(new CompletableTextRegion(), useForDebugging, associatedLocation, parent);
        }

        protected CompletableTraceRegion(CompletableTextRegion region, boolean useForDebugging, ILocationData associatedLocation, AbstractTraceRegion parent) {
            super((ITextRegionWithLineInformation)region, useForDebugging, associatedLocation, parent);
            this.region = region;
        }

        public void complete(int offset, int length, int startLine, int endLine) {
            TextRegionWithLineInformation _textRegionWithLineInformation = new TextRegionWithLineInformation(offset, length, startLine, endLine);
            this.region.delegate = (ITextRegionWithLineInformation)_textRegionWithLineInformation;
        }

        @Override
        protected boolean isConsistentWithParent() {
            return true;
        }

        public static class CompletableTextRegion
        implements ITextRegionWithLineInformation {
            private ITextRegionWithLineInformation delegate;

            @Delegate
            public ITextRegionWithLineInformation getDelegate() {
                if (this.delegate == null) {
                    throw new IllegalStateException("region not completed");
                }
                return this.delegate;
            }

            public boolean contains(ITextRegion arg0) {
                return this.getDelegate().contains(arg0);
            }

            public boolean contains(int arg0) {
                return this.getDelegate().contains(arg0);
            }

            public int getEndLineNumber() {
                return this.getDelegate().getEndLineNumber();
            }

            public int getLength() {
                return this.getDelegate().getLength();
            }

            public int getLineNumber() {
                return this.getDelegate().getLineNumber();
            }

            public int getOffset() {
                return this.getDelegate().getOffset();
            }

            public ITextRegion merge(ITextRegion arg0) {
                return this.getDelegate().merge(arg0);
            }

            public ITextRegionWithLineInformation merge(ITextRegionWithLineInformation arg0) {
                return this.getDelegate().merge(arg0);
            }
        }
    }

    protected static class Context {
        private List<StringBuilder> _lines = CollectionLiterals.newArrayList((Object[])new StringBuilder[]{new StringBuilder()});
        private Deque<IndentNode> _currentIndents = new ArrayDeque<IndentNode>();
        private boolean _pendingIndent = true;
        private AbstractTraceRegion _currentRegion = null;
        private int _contentLength = 0;
        private int _indentLength = 0;

        protected Context() {
        }

        public String currentLineContent() {
            return this._lines.get(this.currentLineNumber()).toString();
        }

        public int contentLength() {
            boolean _isPendingIndent = this.isPendingIndent();
            if (_isPendingIndent) {
                return this._contentLength + this._indentLength;
            }
            return this._contentLength;
        }

        public int currentLineNumber() {
            int _size = this._lines.size();
            return _size - 1;
        }

        public String getContent() {
            return IterableExtensions.join(this._lines);
        }

        public AbstractTraceRegion getCurrentRegion() {
            return this._currentRegion;
        }

        public void increaseIndent(IndentNode node) {
            this._currentIndents.push(node);
            this.recalculateIndentLength();
        }

        public void decreaseIndents() {
            this._currentIndents.pop();
            this.recalculateIndentLength();
        }

        protected int recalculateIndentLength() {
            Functions.Function2 _function = ($0, $1) -> {
                int _length = $1.getIndentationString().length();
                return $0 + _length;
            };
            this._indentLength = (Integer)IterableExtensions.fold(this.getCurrentIndents(), (Object)0, (Functions.Function2)_function);
            return this._indentLength;
        }

        public void appendToCurrentLine(CharSequence chars) {
            int _plus;
            this._lines.get(this.currentLineNumber()).append(chars);
            int _length = chars.length();
            this._contentLength = _plus = this._contentLength + _length;
        }

        public boolean isPendingIndent() {
            return this._pendingIndent;
        }

        public void addNewLine() {
            StringBuilder _stringBuilder = new StringBuilder();
            this._lines.add(_stringBuilder);
        }

        public void setPendingIndent(boolean pending) {
            this._pendingIndent = pending;
        }

        public void resetCurrentLine() {
            boolean _not;
            StringBuilder lineContent = this._lines.get(this.currentLineNumber());
            boolean _isNullOrEmpty = GeneratorNodeProcessor.isNullOrEmpty(lineContent);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                int _minus;
                int _length = lineContent.length();
                this._contentLength = _minus = this._contentLength - _length;
            }
            int _currentLineNumber = this.currentLineNumber();
            StringBuilder _stringBuilder = new StringBuilder();
            this._lines.set(_currentLineNumber, _stringBuilder);
        }

        public void insertIntoCurrentLine(int i, StringBuilder builder) {
            int _plus;
            this._lines.get(this.currentLineNumber()).insert(i, builder);
            int _length = builder.length();
            this._contentLength = _plus = this._contentLength + _length;
        }

        public Deque<IndentNode> getCurrentIndents() {
            return new ArrayDeque<IndentNode>(this._currentIndents);
        }

        public AbstractTraceRegion setCurrentRegion(AbstractTraceRegion region) {
            this._currentRegion = region;
            return this._currentRegion;
        }
    }

    @Data
    public static class Result
    implements CharSequence,
    ITraceRegionProvider {
        @Delegate
        private final CharSequence contents;
        private final AbstractTraceRegion traceRegion;

        @Override
        public AbstractTraceRegion getTraceRegion() throws TraceNotFoundException {
            if (this.traceRegion == null) {
                throw new TraceNotFoundException();
            }
            return this.traceRegion;
        }

        @Override
        public String toString() {
            return this.contents.toString();
        }

        public Result(CharSequence contents, AbstractTraceRegion traceRegion) {
            this.contents = contents;
            this.traceRegion = traceRegion;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
            return 31 * result + (this.traceRegion == null ? 0 : this.traceRegion.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            if (this.contents == null ? other.contents != null : !this.contents.equals(other.contents)) {
                return false;
            }
            return !(this.traceRegion == null ? other.traceRegion != null : !this.traceRegion.equals(other.traceRegion));
        }

        @Pure
        public CharSequence getContents() {
            return this.contents;
        }

        @Override
        public char charAt(int arg0) {
            return this.contents.charAt(arg0);
        }

        @Override
        public IntStream chars() {
            return this.contents.chars();
        }

        @Override
        public IntStream codePoints() {
            return this.contents.codePoints();
        }

        @Override
        public int length() {
            return this.contents.length();
        }

        @Override
        public CharSequence subSequence(int arg0, int arg1) {
            return this.contents.subSequence(arg0, arg1);
        }
    }
}

