/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core.priority;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.text.quicksearch.internal.core.preferences.QuickSearchPreferences;
import org.eclipse.text.quicksearch.internal.core.priority.PriorityFunction;

public class DefaultPriorityFunction
extends PriorityFunction {
    public boolean ignoreDerived = true;
    public String[] ignoredExtensions = new String[]{"~", ".bin", ".bmp", ".class", ".com", ".doc", ".docx", ".exe", ".gif", ".jar", ".jpg", ".jpeg", ".odp", ".odt", ".p12", ".pdf", ".png", ".ppt", ".pptx", ".psd", ".svg", ".xls", ".xlsx", ".zip"};
    public String[] ignoredPrefixes = new String[]{"."};
    public String[] ignoredNames = new String[]{"bin", "build", "target"};
    public Set<IResource> ignoredResources = null;

    @Override
    public double priority(IResource r) {
        if (r != null && r.isAccessible()) {
            if (this.ignoreDerived && r.isDerived()) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.ignoredResources != null && this.ignoredResources.contains(r)) {
                return Double.NEGATIVE_INFINITY;
            }
            String name = r.getName();
            String[] stringArray = this.ignoredExtensions;
            int n = this.ignoredExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (name.regionMatches(true, name.length() - ext.length(), ext, 0, ext.length())) {
                    return Double.NEGATIVE_INFINITY;
                }
                ++n2;
            }
            stringArray = this.ignoredPrefixes;
            n = this.ignoredPrefixes.length;
            n2 = 0;
            while (n2 < n) {
                String pre = stringArray[n2];
                if (name.startsWith(pre)) {
                    return Double.NEGATIVE_INFINITY;
                }
                ++n2;
            }
            stringArray = this.ignoredNames;
            n = this.ignoredNames.length;
            n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                if (name.equals(n3)) {
                    return Double.NEGATIVE_INFINITY;
                }
                ++n2;
            }
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public void configure(QuickSearchPreferences preferences) {
        String[] pref = preferences.getIgnoredExtensions();
        if (pref != null) {
            this.ignoredExtensions = pref;
        }
        if ((pref = preferences.getIgnoredNames()) != null) {
            this.ignoredNames = pref;
        }
        if ((pref = preferences.getIgnoredPrefixes()) != null) {
            this.ignoredPrefixes = pref;
        }
        this.computeIgnoredFolders();
    }

    private void computeIgnoredFolders() {
        IProject[] allprojects;
        IProject[] iProjectArray = allprojects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allprojects.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer[] containers;
            URI location;
            IProject p = iProjectArray[n2];
            if (p.isAccessible() && (location = p.getLocationURI()) != null && (containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(location)) != null) {
                IContainer[] iContainerArray = containers;
                int n3 = containers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IContainer folder = iContainerArray[n4];
                    if (!folder.equals((Object)p)) {
                        this.ignore(folder);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void ignore(IContainer folder) {
        if (this.ignoredResources == null) {
            this.ignoredResources = new HashSet<IResource>();
        }
        this.ignoredResources.add((IResource)folder);
    }
}

