/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.outline;

import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.n4js.tests.builder.AbstractBuilderParticipantTest;
import org.eclipse.n4js.tests.outline.SyncableOutlinePage;
import org.eclipse.n4js.tests.util.EclipseUIUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.IOutlineNodeComparer;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractOutlineWorkbenchTest
extends AbstractBuilderParticipantTest {
    protected static final int ERROR_TIMEOUT = 10000;
    protected static final int EXPECTED_TIMEOUT = 1000;
    protected IOutlineNodeComparer nodeComparer = new IOutlineNodeComparer.Default();
    protected IFile file;
    protected XtextEditor editor;
    protected IXtextDocument document;
    protected IViewPart outlineView;
    protected SyncableOutlinePage outlinePage;
    protected TreeViewer treeViewer;
    protected String modelAsText;
    protected IOutlineNode modelNode;
    protected IPreferenceStore preferenceStore;
    protected IOutlineNodeComparer comparer;

    @Before
    public void setUp2() throws Exception {
        this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.n4js.N4JS");
        this.comparer = new IOutlineNodeComparer.Default();
        if (this.shouldCreateProjectStructure()) {
            this.createProjectStructure();
        }
        this.openXtextDocument();
        this.openOutlineView();
    }

    private void createProjectStructure() throws CoreException {
        IProject project = this.createJSProject(this.getProjectName());
        IFolder folder = this.configureProjectWithXtext(project);
        IFolder moduleFolder = this.createFolder(folder, this.getModuleFolder());
        this.modelAsText = this.getModelAsText();
        this.file = this.createTestFile(moduleFolder, this.getFileName(), this.modelAsText);
        this.assertMarkers("File should have no errors", (IResource)this.file, 0);
    }

    private void openXtextDocument() {
        IWorkbenchPage page = EclipseUIUtils.getActivePage();
        this.editor = this.openAndGetXtextEditor(this.file, page);
        List<Resource.Diagnostic> errors = this.getEditorErrors(this.editor);
        Assert.assertEquals((String)("Editor of " + this.getFileName() + " should have no errors"), (long)0L, (long)errors.size());
        this.document = this.editor.getDocument();
    }

    protected void openOutlineView() throws PartInitException, InterruptedException {
        this.outlineView = this.editor.getEditorSite().getPage().showView("org.eclipse.ui.views.ContentOutline");
        this.executeAsyncDisplayJobs();
        Object adapter = this.editor.getAdapter(IContentOutlinePage.class);
        Assert.assertTrue((boolean)(adapter instanceof OutlinePage));
        this.outlinePage = new SyncableOutlinePage((OutlinePage)adapter);
        this.outlinePage.resetSyncer();
        try {
            this.outlinePage.waitForUpdate(1000L);
        }
        catch (TimeoutException e) {
            System.out.println("Expected timeout exceeded: 1000");
        }
        this.treeViewer = this.outlinePage.getTreeViewer();
        this.assertSelected(this.treeViewer, new IOutlineNode[0]);
        this.assertExpanded(this.treeViewer, new IOutlineNode[0]);
        Assert.assertTrue((boolean)(this.treeViewer.getInput() instanceof IOutlineNode));
        IOutlineNode rootNode = (IOutlineNode)this.treeViewer.getInput();
        List children = rootNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        this.modelNode = (IOutlineNode)children.get(0);
    }

    protected abstract boolean shouldCreateProjectStructure();

    protected abstract String getFileName();

    protected abstract String getModuleFolder();

    protected abstract String getProjectName();

    protected abstract String getModelAsText();

    @After
    public void tearDown2() throws Exception {
        if (this.editor != null) {
            this.editor.close(false);
        }
        if (this.outlineView != null) {
            this.outlineView.getSite().getPage().hideView(this.outlineView);
        }
        this.executeAsyncDisplayJobs();
    }

    protected void assertExpanded(TreeViewer aTreeViewer, IOutlineNode ... expectedExpansion) {
        Object[] expandedElements = aTreeViewer.getExpandedElements();
        Assert.assertEquals((long)expectedExpansion.length, (long)expandedElements.length);
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                Object expandedObject = objectArray[n2];
                Assert.assertTrue((boolean)(expandedObject instanceof IOutlineNode));
                IOutlineNode[] iOutlineNodeArray = expectedExpansion;
                int n3 = expectedExpansion.length;
                int n4 = 0;
                while (n4 < n3) {
                    IOutlineNode expectedExpanded = iOutlineNodeArray[n4];
                    if (!this.nodeComparer.equals((IOutlineNode)expandedObject, expectedExpanded)) {
                        ++n4;
                        continue;
                    }
                    break block3;
                }
                Assert.fail((String)("Unexpected expansion" + expandedObject.toString()));
            }
            ++n2;
        }
    }

    protected void assertSelected(TreeViewer aTreeViewer, IOutlineNode ... expectedSelection) {
        ISelection selection = aTreeViewer.getSelection();
        Assert.assertTrue((boolean)(selection instanceof IStructuredSelection));
        Assert.assertEquals((long)expectedSelection.length, (long)((IStructuredSelection)selection).size());
        block0: for (Object selectedObject : (IStructuredSelection)selection) {
            Assert.assertTrue((boolean)(selectedObject instanceof IOutlineNode));
            IOutlineNode[] iOutlineNodeArray = expectedSelection;
            int n = expectedSelection.length;
            int n2 = 0;
            while (n2 < n) {
                IOutlineNode expectedSelected = iOutlineNodeArray[n2];
                if (this.nodeComparer.equals((IOutlineNode)selectedObject, expectedSelected)) continue block0;
                ++n2;
            }
            Assert.fail((String)("Unexpected selection " + selectedObject.toString()));
        }
    }

    protected void assertSame(IOutlineNode node, TreeItem treeItem) {
        Assert.assertTrue((boolean)(treeItem.getData() instanceof IOutlineNode));
        Assert.assertTrue((boolean)this.comparer.equals(node, (IOutlineNode)treeItem.getData()));
    }

    protected void activate(IWorkbenchPart part) {
        this.editor.getSite().getPage().activate(part);
    }

    protected void executeAsyncDisplayJobs() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }
}

