/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.generator.ICompositeGenerator;
import org.eclipse.n4js.ui.building.N4JSResourceSetCleanerUtils;
import org.eclipse.n4js.ui.building.instructions.BuildInstruction;
import org.eclipse.n4js.ui.building.instructions.CleanInstruction;
import org.eclipse.n4js.ui.building.instructions.IBuildParticipantInstruction;
import org.eclipse.xtext.builder.BuilderParticipant;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.util.ResourceUtil;

@Singleton
public class N4JSBuilderParticipant
extends BuilderParticipant {
    @Inject
    private Provider<EclipseResourceFileSystemAccess2> fileSystemAccessProvider;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private Injector injector;
    @Inject
    private ICompositeGenerator compositeGenerator;

    IBuildParticipantInstruction prepareBuild(IProject project, IXtextBuilderParticipant.BuildType buildType) throws CoreException {
        if (!this.isEnabled(project)) {
            return IBuildParticipantInstruction.NOOP;
        }
        EclipseResourceFileSystemAccess2 access = (EclipseResourceFileSystemAccess2)this.fileSystemAccessProvider.get();
        access.setProject(project);
        Map<String, OutputConfiguration> outputConfigurations = this.getOutputConfigurations(project);
        this.refreshOutputFolders(project, outputConfigurations, null);
        access.setOutputConfigurations(outputConfigurations);
        if (buildType == IXtextBuilderParticipant.BuildType.CLEAN || buildType == IXtextBuilderParticipant.BuildType.RECOVERY) {
            CleanInstruction clean = new CleanInstruction(project, outputConfigurations, this.getDerivedResourceMarkers());
            if (buildType == IXtextBuilderParticipant.BuildType.RECOVERY) {
                clean.finish(Collections.emptyList(), null);
            } else {
                return clean;
            }
        }
        Map<OutputConfiguration, Iterable<IMarker>> generatorMarkers = this.getGeneratorMarkers(project, outputConfigurations.values());
        BuildInstruction buildInstruction = new BuildInstruction(project, outputConfigurations, this.getDerivedResourceMarkers(), access, generatorMarkers, this.storage2UriMapper, this.compositeGenerator, this.injector);
        return buildInstruction;
    }

    protected boolean isEnabled(IProject project) {
        return this.getBuilderPreferenceAccess().isAutoBuildEnabled((Object)project);
    }

    protected void refreshOutputFolders(IProject project, Map<String, OutputConfiguration> outputConfigurations, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)outputConfigurations.size());
        for (OutputConfiguration config : outputConfigurations.values()) {
            SubMonitor child = subMonitor.newChild(1);
            IContainer container = ResourceUtil.getContainer((IProject)project, (String)config.getOutputDirectory());
            if (container == null) continue;
            container.refreshLocal(2, (IProgressMonitor)child);
        }
    }

    protected Map<String, OutputConfiguration> getOutputConfigurations(IProject project) {
        Set configurations = this.getOutputConfigurationProvider().getOutputConfigurations(project);
        return Maps.uniqueIndex(this.getNonNullOutputConfigurations(configurations), (Function)new Function<OutputConfiguration, String>(){

            public String apply(OutputConfiguration from) {
                return from.getName();
            }
        });
    }

    private Iterable<OutputConfiguration> getNonNullOutputConfigurations(Set<OutputConfiguration> configurations) {
        if (configurations == null) {
            return new HashSet<OutputConfiguration>();
        }
        return configurations;
    }

    public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        IBuildParticipantInstruction delegate = (IBuildParticipantInstruction)EcoreUtil.getAdapter((List)context.getResourceSet().eAdapters(), IBuildParticipantInstruction.class);
        if (delegate == null) {
            if (context.getBuildType() == IXtextBuilderParticipant.BuildType.CLEAN) {
                super.build(context, monitor);
            }
        } else {
            delegate.finish(context.getDeltas(), monitor);
            if (delegate.isRebuild()) {
                context.needRebuild();
            }
        }
    }

    protected void clearResourceSet(ResourceSet resourceSet) {
        N4JSResourceSetCleanerUtils.clearResourceSet(resourceSet);
    }

    protected Map<OutputConfiguration, Iterable<IMarker>> getGeneratorMarkers(IProject builtProject, Collection<OutputConfiguration> outputConfigurations) throws CoreException {
        if (builtProject instanceof ExternalProject) {
            return Collections.emptyMap();
        }
        HashMap generatorMarkers = Maps.newHashMap();
        for (OutputConfiguration config : outputConfigurations) {
            if (!config.isCleanUpDerivedResources()) continue;
            ArrayList markers = Lists.newArrayList();
            for (IContainer container : this.getOutputs(builtProject, config)) {
                Iterables.addAll((Collection)markers, (Iterable)this.getDerivedResourceMarkers().findDerivedResourceMarkers((IResource)container, this.getGeneratorIdProvider().getGeneratorIdentifier()));
            }
            generatorMarkers.put(config, markers);
        }
        return generatorMarkers;
    }
}

