/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.binaries.nodejs.YarnBinary;

@Singleton
public class BinariesProvider {
    private static final Iterable<Class<? extends Binary>> REGISTERED_BINARIES = ImmutableList.builder().add(NodeJsBinary.class).add(YarnBinary.class).build();
    @Inject
    private Injector injector;

    public Iterable<Binary> getRegisteredBinaries() {
        return FluentIterable.from(REGISTERED_BINARIES).transform(clazz -> (Binary)this.injector.getInstance(clazz)).toList();
    }

    public List<String> validateBinaries() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        this.collectBinariesErrors(this.getRegisteredBinaries(), errorMessages);
        return errorMessages;
    }

    private void collectBinariesErrors(Iterable<Binary> binaries, List<String> addErrorsHere) {
        for (Binary binary : binaries) {
            IStatus status = binary.validate();
            if (!status.isOK()) {
                addErrorsHere.add(status.getMessage());
                continue;
            }
            this.collectBinariesErrors(binary.getChildren(), addErrorsHere);
        }
    }
}

