/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.external.ShadowingInfoHelper;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.navigator.internal.NamedNode;
import org.eclipse.n4js.ui.navigator.internal.Node;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.graphics.Image;

@Singleton
public class N4JSProjectExplorerHelper {
    @Inject
    private IN4JSCore core;
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private ExternalLibraryPreferenceStore prefStore;
    @Inject
    private ExternalIndexSynchronizer indexSynchronizer;
    @Inject
    private ShadowingInfoHelper shadowingInfoHelper;

    public IN4JSProject getProject(IProject project) {
        Preconditions.checkArgument((!(project instanceof ExternalProject) ? 1 : 0) != 0, (Object)("Expected Eclipse workspace project. Got: " + project));
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        String projectName = Strings.nullToEmpty((String)project.getName());
        IN4JSProject n4Project = this.core.create(URI.createPlatformResourceURI((String)projectName, (boolean)true));
        if (n4Project == null || !n4Project.exists() || n4Project.isExternal()) {
            return null;
        }
        return n4Project;
    }

    public boolean isSourceFolder(IFolder folder) {
        IN4JSProject project = this.getProject(folder.getProject());
        if (project != null) {
            String relativePath = Strings.nullToEmpty((String)folder.getProjectRelativePath().toOSString());
            for (IN4JSSourceContainer srcContainer : project.getSourceContainers()) {
                String relSrcCont = Strings.nullToEmpty((String)srcContainer.getRelativeLocation());
                if (!relativePath.equals(relSrcCont) && !relSrcCont.startsWith(String.valueOf(relativePath) + File.separator)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOutputFolder(IFolder folder) {
        IN4JSProject project = this.getProject(folder.getProject());
        if (project != null) {
            String outputPath;
            String relativePath = Strings.nullToEmpty((String)folder.getProjectRelativePath().toOSString());
            return relativePath.equals(outputPath = Strings.nullToEmpty((String)project.getOutputPath())) || outputPath.startsWith(String.valueOf(relativePath) + File.separator);
        }
        return false;
    }

    public N4JSExternalProject getNodeModulesNpmProjectOrNull(IFolder folder) {
        return this.externalLibraryWorkspace.getProject(new FileURI(folder.getLocation().toFile()));
    }

    public boolean isNodeModulesNpmProject(IFolder folder) {
        IContainer parentContainer = folder.getParent();
        if (parentContainer instanceof IFolder) {
            return this.isNodeModulesFolder(parentContainer);
        }
        return false;
    }

    public boolean isNodeModulesFolder(IContainer container) {
        if ("node_modules".equals(container.getName()) && container instanceof IFolder) {
            IPath path = container.getLocation();
            FileURI locURI = new FileURI(path.toFile());
            if (this.prefStore.getNodeModulesLocations().contains(locURI)) {
                return true;
            }
        }
        return false;
    }

    public StyledString getStyledTextForExternalProject(IN4JSProject project, N4JSProjectName overrideProjectName) {
        N4JSProjectName name = overrideProjectName == null ? project.getProjectName() : overrideProjectName;
        ProjectType type = project.getProjectType();
        String version = SemverSerializer.serialize((VersionNumber)project.getVersion()).replaceFirst("@", "v");
        String typeLabel = this.getProjectTypeLabel(type);
        boolean inIndex = project.isExternal() && this.indexSynchronizer.isInIndex((FileURI)project.getProjectDescriptionLocation());
        String rootLocationName = this.getRootLocationName(project);
        StyledString.Styler stylerName = inIndex ? null : StyledString.QUALIFIER_STYLER;
        StyledString.Styler stylerType = inIndex ? StyledString.DECORATIONS_STYLER : StyledString.QUALIFIER_STYLER;
        StyledString string = new StyledString(name + " " + version, stylerName);
        string.append(typeLabel, stylerType);
        if (rootLocationName != null) {
            string.append(rootLocationName, StyledString.COUNTER_STYLER);
        }
        return string;
    }

    private String getRootLocationName(IN4JSProject project) {
        String rootLocationName = null;
        List shadowingProjects = this.shadowingInfoHelper.findShadowingProjects(project);
        if (!shadowingProjects.isEmpty()) {
            IN4JSProject shadowedProject = (IN4JSProject)shadowingProjects.get(0);
            if (shadowedProject.isExternal()) {
                FileURI location = (FileURI)shadowedProject.getLocation();
                FileURI rootLocation = this.externalLibraryWorkspace.getRootLocationForResource(location);
                if (rootLocation != null) {
                    Path rootPath = rootLocation.toFileSystemPath();
                    Path subpath = rootPath.subpath(rootPath.getNameCount() - 2, rootPath.getNameCount());
                    rootLocationName = subpath.toString();
                } else {
                    rootLocationName = "unknown";
                }
            } else {
                rootLocationName = "workspace";
            }
            rootLocationName = " [shadowed by " + rootLocationName + "]";
        }
        return rootLocationName;
    }

    private String getProjectTypeLabel(ProjectType projectType) {
        String label = ProjectType.API.equals((Object)projectType) ? ProjectType.API.getName() : org.eclipse.xtext.util.Strings.toFirstUpper((String)Strings.nullToEmpty((String)projectType.getName()).replaceAll("_", " ").toLowerCase());
        return " [" + label + "]";
    }

    public Node[] getVirtualNodesForProject(IProject project) {
        Node[] nodeArray;
        Preconditions.checkArgument((!(project instanceof ExternalProject) ? 1 : 0) != 0, (Object)("Expected Eclipse workspace project. Got: " + project));
        if (project == null || !project.exists() || !project.isAccessible()) {
            return Node.EMPTY_NODES;
        }
        IN4JSProject n4Project = this.getProject(project);
        if (n4Project == null || !n4Project.exists() || n4Project.isExternal()) {
            return Node.EMPTY_NODES;
        }
        Image image = (Image)ImageDescriptorCache.ImageRef.LIB_PATH.asImage().get();
        NamedNode rootNode = new NamedNode(project, "External Dependencies", image);
        if (Arrays2.isEmpty((Object[])rootNode.getChildren())) {
            nodeArray = Node.EMPTY_NODES;
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = rootNode;
        }
        return nodeArray;
    }
}

