/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.File;
import java.util.Map;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc2spec.KeyUtils;
import org.eclipse.n4js.jsdoc2spec.RepoRelativePath;
import org.eclipse.n4js.jsdoc2spec.SpecInfo;
import org.eclipse.n4js.jsdoc2spec.adoc.ADocFactory;
import org.eclipse.n4js.jsdoc2spec.adoc.FileSystem;
import org.eclipse.n4js.jsdoc2spec.adoc.RepoRelativePathHolder;
import org.eclipse.n4js.jsdoc2spec.adoc.SourceEntry;
import org.eclipse.n4js.jsdoc2spec.adoc.SourceEntryFactory;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecSection;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TMember;

public class SpecIdentifiableElementSection
extends SpecSection {
    final IdentifiableElement typeElement;
    final IdentifiableElement idElement;
    final String specModuleKey;
    final String specKey;
    final SourceEntry sourceEntry;
    private Doclet doclet;

    SpecIdentifiableElementSection(SpecInfo specInfo, File rootDir, RepoRelativePathHolder repoPathHolder) {
        super(specInfo, rootDir);
        this.typeElement = specInfo.specElementRef.identifiableElement;
        this.idElement = specInfo.specElementRef.identifiableElement;
        this.specModuleKey = KeyUtils.getSpecModuleKey(repoPathHolder, specInfo);
        this.sourceEntry = this.getSourceEntry(repoPathHolder);
        this.specKey = this.sourceEntry.toPQN();
    }

    SpecIdentifiableElementSection(SpecInfo specInfo, TMember idElement, File rootDir, RepoRelativePathHolder repoPathHolder) {
        super(specInfo, rootDir);
        this.typeElement = specInfo.specElementRef.identifiableElement;
        this.idElement = idElement;
        this.specModuleKey = KeyUtils.getSpecModuleKey(repoPathHolder, specInfo);
        this.sourceEntry = this.getSourceEntry(repoPathHolder);
        this.specKey = this.sourceEntry.toPQN();
    }

    public SpecIdentifiableElementSection(IdentifiableElement element, RepoRelativePathHolder repoPathHolder) {
        super(null, null);
        if (element instanceof TMember) {
            ContainerType containingType = ((TMember)element).getContainingType();
            this.typeElement = containingType;
        } else {
            this.typeElement = element;
        }
        this.idElement = element;
        this.specModuleKey = element.getName();
        this.specKey = KeyUtils.getSpecKey(repoPathHolder, this.idElement);
        this.sourceEntry = this.getSourceEntry(repoPathHolder);
    }

    @Override
    public String getSpecModuleKey() {
        return this.specModuleKey;
    }

    @Override
    public String getSpecKey() {
        return this.specKey;
    }

    @Override
    public File getFile() {
        String fileName = this.rootDir + FileSystem.SEP + "api-gen" + FileSystem.SEP;
        fileName = String.valueOf(fileName) + "modules" + FileSystem.SEP;
        fileName = String.valueOf(fileName) + this.sourceEntry.adocPath;
        return new File(fileName);
    }

    public IdentifiableElement getIdentifiableElement() {
        return this.idElement;
    }

    public SourceEntry getSourceEntry() {
        return this.sourceEntry;
    }

    private SourceEntry getSourceEntry(RepoRelativePathHolder repoPathHolder) {
        RepoRelativePath rrp = repoPathHolder.get(this.typeElement);
        SourceEntry se = SourceEntryFactory.create(repoPathHolder, rrp, this.idElement);
        return se;
    }

    public void setDoclet(Doclet doclet) {
        this.doclet = doclet;
    }

    public Doclet getDoclet() {
        return this.doclet;
    }

    @Override
    protected String computeADocText(ADocFactory adocFactory, Map<String, SpecSection> specsByKey) {
        CharSequence regionStr = adocFactory.createSpecRegionString(this, specsByKey);
        return regionStr.toString();
    }
}

