/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.organize.imports;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.AnnotationArgument;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.TypeRefAnnotationArgument;
import org.eclipse.n4js.organize.imports.DIUtility;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class InjectedTypesResolverUtility {
    public static Collection<Type> findAllInjected(Script script) {
        ArrayList injections = CollectionLiterals.newArrayList();
        Procedures.Procedure1 _function = cl -> {
            boolean _hasOwnedAnnotation_1;
            Consumer<TFormalParameter> _function_1 = it -> injections.add(InjectedTypesResolverUtility.getDeclaredTypeFromTypeRef(it.getTypeRef()));
            InjectedTypesResolverUtility.getOwnedInjectedCtorParams(cl).forEach(_function_1);
            Consumer<N4FieldDeclaration> _function_2 = f -> {
                boolean _hasAnnotation = AnnotationDefinition.INJECT.hasAnnotation((AnnotableElement)f);
                if (_hasAnnotation) {
                    injections.add(InjectedTypesResolverUtility.getDeclaredTypeFromTypeRef(f.getDeclaredTypeRef()));
                }
            };
            cl.getOwnedFields().forEach(_function_2);
            boolean _hasOwnedAnnotation = AnnotationDefinition.BINDER.hasOwnedAnnotation((AnnotableElement)cl);
            if (_hasOwnedAnnotation) {
                Consumer<Annotation> _function_3 = an -> {
                    EObject _value = ((AnnotationArgument)IterableExtensions.head((Iterable)an.getArgs())).value();
                    injections.add(InjectedTypesResolverUtility.getDeclaredTypeFromTypeRef((TypeRef)_value));
                    EObject _value_1 = ((AnnotationArgument)IterableExtensions.last((Iterable)an.getArgs())).value();
                    injections.add(InjectedTypesResolverUtility.getDeclaredTypeFromTypeRef((TypeRef)_value_1));
                };
                AnnotationDefinition.BIND.getAllOwnedAnnotations((AnnotableElement)cl).forEach(_function_3);
                Consumer<N4MethodDeclaration> _function_4 = m -> {
                    boolean _hasAnnotation = AnnotationDefinition.PROVIDES.hasAnnotation((AnnotableElement)m);
                    if (_hasAnnotation) {
                        injections.add(InjectedTypesResolverUtility.getDeclaredTypeFromTypeRef(m.getReturnTypeRef()));
                        Consumer<FormalParameter> _function_5 = it -> injections.add(InjectedTypesResolverUtility.getDeclaredTypeFromTypeRef(it.getDeclaredTypeRef()));
                        m.getFpars().forEach(_function_5);
                    }
                };
                cl.getOwnedMethods().forEach(_function_4);
            }
            if (_hasOwnedAnnotation_1 = AnnotationDefinition.GENERATE_INJECTOR.hasOwnedAnnotation((AnnotableElement)cl)) {
                Iterable<Annotation> anns;
                boolean _hasOwnedAnnotation_3;
                Annotation ann;
                boolean _hasOwnedAnnotation_2 = AnnotationDefinition.WITH_PARENT_INJECTOR.hasOwnedAnnotation((AnnotableElement)cl);
                if (_hasOwnedAnnotation_2 && (ann = AnnotationDefinition.WITH_PARENT_INJECTOR.getOwnedAnnotation((AnnotableElement)cl)) != null) {
                    AnnotationArgument _head = (AnnotationArgument)IterableExtensions.head((Iterable)ann.getArgs());
                    injections.add(((TypeRefAnnotationArgument)_head).getTypeRef().getDeclaredType());
                }
                if ((_hasOwnedAnnotation_3 = AnnotationDefinition.USE_BINDER.hasOwnedAnnotation((AnnotableElement)cl)) && (anns = AnnotationDefinition.USE_BINDER.getAllOwnedAnnotations((AnnotableElement)cl)) != null) {
                    Functions.Function1 _function_5 = it -> {
                        AnnotationArgument _head_1 = (AnnotationArgument)IterableExtensions.head((Iterable)it.getArgs());
                        return (TypeRefAnnotationArgument)_head_1;
                    };
                    Functions.Function1 _function_6 = it -> it.getTypeRef().getDeclaredType();
                    Iterable argsTypes = IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(anns, (Functions.Function1)_function_5)), (Functions.Function1)_function_6);
                    Consumer<Type> _function_7 = it -> injections.add(it);
                    argsTypes.forEach(_function_7);
                }
            }
        };
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)script.eAllContents(), N4ClassifierDefinition.class), (Procedures.Procedure1)_function);
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)injections));
    }

    private static List<TFormalParameter> getOwnedInjectedCtorParams(N4ClassifierDefinition it) {
        boolean _hasAnnotation;
        Type _definedType_1;
        TMethod ctor;
        Type _definedType = null;
        if (it != null) {
            _definedType = it.getDefinedType();
        }
        if (_definedType instanceof TClass && (ctor = ((TClass)(_definedType_1 = it.getDefinedType())).getOwnedCtor()) != null && (_hasAnnotation = AnnotationDefinition.INJECT.hasAnnotation((TAnnotableElement)ctor))) {
            return ctor.getFpars();
        }
        return CollectionLiterals.emptyList();
    }

    private static Type getDeclaredTypeFromTypeRef(TypeRef typeRef) {
        Type _xifexpression = null;
        boolean _isProviderType = DIUtility.isProviderType(typeRef);
        if (_isProviderType) {
            Type providedType = DIUtility.getProvidedType(typeRef);
            if (providedType != null) {
                return providedType;
            }
        } else {
            _xifexpression = typeRef.getDeclaredType();
        }
        return _xifexpression;
    }
}

