/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.process;

import com.google.inject.Singleton;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.n4js.utils.io.OutputRedirection;
import org.eclipse.n4js.utils.io.OutputStreamPrinterThreadProvider;
import org.eclipse.n4js.utils.process.ProcessResult;

@Singleton
public class ProcessExecutor {
    @Inject
    private OutputStreamPrinterThreadProvider printerThreadProvider;
    private static final long DEFAULT_TIMEOUT = 240L;
    private static final int ERROR_EXIT_CODE = -1;
    private static final Logger LOGGER = Logger.getLogger(ProcessExecutor.class);

    public ProcessResult execute(Process process) {
        return this.execute(process, null, OutputRedirection.SUPPRESS);
    }

    public ProcessResult execute(Process process, String processName, OutputRedirection redirect) {
        return this.execute(process, processName, redirect, 240L, TimeUnit.SECONDS);
    }

    /*
     * Exception decompiling
     */
    public ProcessResult execute(Process process, String processName, OutputRedirection redirect, long timeout, TimeUnit timeoutUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ProcessResult createAndExecute(ProcessBuilder processBuilder) {
        return this.createAndExecute(processBuilder, null, OutputRedirection.SUPPRESS);
    }

    public ProcessResult createAndExecute(ProcessBuilder processBuilder, String name, OutputRedirection redirect) {
        String pbName;
        String string = pbName = name == null ? " <unnamed> " : " for process '" + name + "' ";
        if (processBuilder == null) {
            LOGGER.error((Object)("Provided process builder" + pbName + "was null"));
            return new ProcessResult(-1, "", "");
        }
        try {
            return this.execute(processBuilder.start(), name, redirect);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Cannot start process from process builder" + pbName), (Throwable)e);
            return new ProcessResult(-1, "", "");
        }
    }

    private String writeStackeTrace(Throwable t) {
        StringBuilder sb = new StringBuilder(t.getClass().getName());
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append("\tat ").append(element.getClassName()).append(".").append(element.getMethodName()).append("(").append(element.getFileName()).append(":").append(element.getLineNumber()).append(")");
            ++n2;
        }
        return sb.toString();
    }
}

