/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.features.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.views.features.support.FeatureSupport;
import org.eclipse.pde.internal.ui.views.features.support.PluginSupport;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ResourceTransfer;

public class FeatureAndPluginCopyAction
extends Action {
    private final StructuredViewer fStructuredViewer;
    private final Clipboard fClipboard;

    public FeatureAndPluginCopyAction(StructuredViewer structuredViewer, Clipboard clipboard) {
        super(PDEUIMessages.FeaturesView_FeatureAndPluginCopyAction_label, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.fStructuredViewer = structuredViewer;
        this.fClipboard = clipboard;
        this.setActionDefinitionId(ActionFactory.COPY.getCommandId());
    }

    public void runWithEvent(Event event) {
        IStructuredSelection selection = this.fStructuredViewer.getStructuredSelection();
        List<IModel> models = this.toModels(selection);
        String textData = this.toTextData(models);
        IResource[] projectResources = this.toProjectResources(models);
        String[] fileData = this.toFileData(projectResources);
        Object[] data = new Object[]{textData, projectResources, fileData};
        Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        this.fClipboard.setContents(data, dataTypes);
    }

    private List<IModel> toModels(IStructuredSelection selection) {
        List selectionList = selection.toList();
        return selectionList.stream().map(this::toModel).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private IModel toModel(Object element) {
        IFeatureModel model = FeatureSupport.toFeatureModel(element);
        if (model == null) {
            model = PluginSupport.toPluginModel(element);
        }
        return model;
    }

    private String toTextData(Collection<IModel> models) {
        return models.stream().map(this::toModelId).collect(Collectors.joining(System.lineSeparator()));
    }

    private String toModelId(IModel model) {
        if (model instanceof IFeatureModel) {
            return ((IFeatureModel)model).getFeature().getId();
        }
        if (model instanceof IPluginModelBase) {
            return ((IPluginModelBase)model).getPluginBase().getId();
        }
        return null;
    }

    private IResource[] toProjectResources(Collection<IModel> models) {
        return (IResource[])models.stream().map(IModel::getUnderlyingResource).filter(Objects::nonNull).map(IResource::getProject).distinct().toArray(IResource[]::new);
    }

    private String[] toFileData(IResource[] resources) {
        return (String[])Arrays.stream(resources).map(resource -> resource.getLocation().toOSString()).toArray(String[]::new);
    }
}

