/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.build;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ide.xtext.server.build.XClusteringStorageAwareResourceLoader;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;

public class XBuildContext {
    private final Functions.Function1<? super URI, ? extends IResourceServiceProvider> resourceServiceProviderProvider;
    private final XtextResourceSet resourceSet;
    private final XIndexState oldState;
    private final IResourceClusteringPolicy clusteringPolicy;
    private final CancelIndicator cancelIndicator;
    private XClusteringStorageAwareResourceLoader loader;

    public XBuildContext(Functions.Function1<? super URI, ? extends IResourceServiceProvider> resourceServiceProviderProvider, XtextResourceSet resourceSet, XIndexState oldState, IResourceClusteringPolicy clusteringPolicy, CancelIndicator cancelIndicator) {
        this.resourceServiceProviderProvider = resourceServiceProviderProvider;
        this.resourceSet = resourceSet;
        this.oldState = oldState;
        this.clusteringPolicy = clusteringPolicy;
        this.cancelIndicator = cancelIndicator;
    }

    public <T> Iterable<T> executeClustered(Iterable<URI> uri, Functions.Function1<? super Resource, ? extends T> operation) {
        if (this.loader == null) {
            this.loader = new XClusteringStorageAwareResourceLoader(this);
        }
        return this.loader.executeClustered(Iterables.filter(uri, this::canHandle), operation);
    }

    protected boolean canHandle(URI uri) {
        IResourceServiceProvider resourceServiceProvider = this.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return false;
        }
        return resourceServiceProvider.canHandle(uri);
    }

    public IResourceServiceProvider getResourceServiceProvider(URI uri) {
        return (IResourceServiceProvider)this.resourceServiceProviderProvider.apply((Object)uri);
    }

    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public XIndexState getOldState() {
        return this.oldState;
    }

    public IResourceClusteringPolicy getClusteringPolicy() {
        return this.clusteringPolicy;
    }

    public CancelIndicator getCancelIndicator() {
        return this.cancelIndicator;
    }
}

