/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow.symbols;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.xtext.xbase.lib.Pair;

public class SymbolContextUtils {
    public static List<Symbol> getContextsToAlias(Symbol symbolWithContext, Symbol alias) {
        if (alias == null) {
            return Collections.emptyList();
        }
        LinkedList<Symbol> contexts = new LinkedList<Symbol>();
        contexts.add(symbolWithContext);
        while (symbolWithContext.getContextSymbol() != null) {
            if (alias.equals(symbolWithContext = symbolWithContext.getContextSymbol())) {
                return contexts;
            }
            contexts.add(0, symbolWithContext);
        }
        return Collections.emptyList();
    }

    public static Pair<Symbol, List<Symbol>> getSymbolAndContextsToAlias(Iterable<Symbol> symbolsWithContexts, Symbol alias) {
        Symbol matchedAlias = null;
        List<Object> contextList = Collections.emptyList();
        for (Symbol symbolWithContext : symbolsWithContexts) {
            List<Symbol> contextListTmp = SymbolContextUtils.getContextsToAlias(symbolWithContext, alias);
            if (contextListTmp.isEmpty()) continue;
            matchedAlias = symbolWithContext;
            contextList = contextListTmp;
        }
        Pair symbolAndContexts = Pair.of(matchedAlias, contextList);
        return symbolAndContexts;
    }

    public static Pair<Symbol, Symbol> getContextChangedSymbol(SymbolFactory symbolFactory, Iterable<Symbol> symbolsWithContexts, Symbol alias, Expression baseExpression) {
        Pair<Symbol, List<Symbol>> symbolAndContexts = SymbolContextUtils.getSymbolAndContextsToAlias(symbolsWithContexts, alias);
        Symbol matchedAlias = (Symbol)symbolAndContexts.getKey();
        List contextList = (List)symbolAndContexts.getValue();
        Symbol synthSymbol = null;
        if (!contextList.isEmpty()) {
            synthSymbol = symbolFactory.create(baseExpression, contextList);
        }
        Pair cSymbols = Pair.of((Object)matchedAlias, synthSymbol);
        return cSymbols;
    }
}

