/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.accessModifiers;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.extensions.ExpressionExtensions;
import org.eclipse.n4js.scoping.accessModifiers.InvalidStaticWriteAccessDescription;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.xtext.scoping.FilterWithErrorMarkerScope;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class StaticWriteAccessFilterScope
extends FilterWithErrorMarkerScope {
    private final EObject context;
    private String memberTypeName = "-not initialised-";
    private String memberTypeAlias = null;

    public StaticWriteAccessFilterScope(IScope parent, EObject context) {
        super(parent);
        this.context = context;
    }

    protected IEObjectDescriptionWithError wrapFilteredDescription(IEObjectDescription result) {
        return new InvalidStaticWriteAccessDescription(result, this.memberTypeName, this.memberTypeAlias);
    }

    protected boolean isAccepted(IEObjectDescription description) {
        TMember member;
        EObject proxyOrInstance = description.getEObjectOrProxy();
        if (proxyOrInstance instanceof TMember && !proxyOrInstance.eIsProxy() && (member = (TMember)proxyOrInstance).isStatic() && member.isWriteable() && this.isWriteAccess()) {
            ContainerType memberType = member.getContainingType();
            this.memberTypeName = memberType.getName();
            boolean isTargetGivenByIdentifier = this.getTarget() instanceof IdentifierRef;
            if (!isTargetGivenByIdentifier) {
                return false;
            }
            IdentifierRef idref = (IdentifierRef)this.getTarget();
            if (idref.getId().getName().equals(this.memberTypeName)) {
                return true;
            }
            Script sc = (Script)EcoreUtil2.getContainerOfType((EObject)this.context, Script.class);
            Optional<NamedImportSpecifier> namedImport = sc.getScriptElements().stream().filter(se -> se instanceof ImportDeclaration).map(se -> (ImportDeclaration)se).flatMap(idecl -> idecl.getImportSpecifiers().stream().filter(is -> is instanceof NamedImportSpecifier).map(is -> (NamedImportSpecifier)is)).filter(s -> s.getImportedElement() == memberType).findFirst();
            if (namedImport.isPresent()) {
                this.memberTypeAlias = namedImport.get().getAlias();
            }
            return false;
        }
        return true;
    }

    private Expression getTarget() {
        if (this.context instanceof ParameterizedPropertyAccessExpression) {
            ParameterizedPropertyAccessExpression ppae = (ParameterizedPropertyAccessExpression)this.context;
            return ppae.getTarget();
        }
        if (this.context instanceof IndexedAccessExpression) {
            IndexedAccessExpression iae = (IndexedAccessExpression)this.context;
            return iae.getTarget();
        }
        return null;
    }

    private boolean isWriteAccess() {
        if (!this.canAppearInLHSPosition()) {
            return false;
        }
        return ExpressionExtensions.isLeftHandSide(this.context) || ExpressionExtensions.isIncOrDecTarget(this.context);
    }

    private boolean canAppearInLHSPosition() {
        return this.context instanceof ParameterizedPropertyAccessExpression || this.context instanceof IndexedAccessExpression;
    }
}

