/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.selection;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

public class RepositorySourceProvider
extends AbstractSourceProvider
implements ISelectionListener,
IWindowListener {
    public static final String REPOSITORY_PROPERTY = "org.eclipse.egit.ui.currentRepository";
    private WeakReference<Repository> repositoryRef;

    public void initialize(IServiceLocator locator) {
        super.initialize(locator);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
    }

    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
        this.repositoryRef = null;
    }

    public Map getCurrentState() {
        Repository repository;
        Repository repository2 = repository = this.repositoryRef == null ? null : (Repository)this.repositoryRef.get();
        if (repository == null) {
            return Collections.singletonMap(REPOSITORY_PROPERTY, "");
        }
        return Collections.singletonMap(REPOSITORY_PROPERTY, repository.getDirectory().getAbsolutePath());
    }

    public String[] getProvidedSourceNames() {
        return new String[]{REPOSITORY_PROPERTY};
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Repository currentRepository;
        Repository newRepository = selection == null ? null : SelectionUtils.getRepository(SelectionUtils.getStructuredSelection(selection));
        Repository repository = currentRepository = this.repositoryRef == null ? null : (Repository)this.repositoryRef.get();
        if (currentRepository == null && this.repositoryRef != null) {
            this.repositoryRef = null;
            if (newRepository == null) {
                this.fireSourceChanged(16384, REPOSITORY_PROPERTY, "");
                return;
            }
        }
        if (currentRepository != newRepository) {
            if (newRepository != null) {
                this.repositoryRef = new WeakReference<Repository>(newRepository);
                this.fireSourceChanged(16384, REPOSITORY_PROPERTY, newRepository.getDirectory().getAbsolutePath());
            } else {
                this.repositoryRef = null;
                this.fireSourceChanged(16384, REPOSITORY_PROPERTY, "");
            }
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
        window.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }
}

