/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public abstract class GenerateXpectReportShortcut
implements ILaunchShortcut {
    private static void showDialogNotImplemented(String what) {
        MessageDialog.openWarning(null, (String)"Warning", (String)("Launching of type " + what + " is not implemented yet!"));
    }

    public void launch(ISelection selection, String mode) {
        Object selectObj = ((IStructuredSelection)selection).getFirstElement();
        if (selectObj instanceof IFile) {
            this.generateBug((IFile)selectObj);
        } else {
            GenerateXpectReportShortcut.showDialogNotImplemented(selection.getClass().getName());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile selectObj = ((IFileEditorInput)editorInput).getFile();
            this.generateBug(selectObj);
        } else {
            GenerateXpectReportShortcut.showDialogNotImplemented(editor.getClass().getName());
        }
    }

    protected void generateBug(IFile fileSelectedToRun) {
        String content = "";
        try {
            content = new String(Files.readAllBytes(Paths.get(fileSelectedToRun.getRawLocationURI())));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read provided file " + fileSelectedToRun.getName(), e);
        }
        System.out.println(content);
        this.generateAndDisplayReport(fileSelectedToRun.getName(), content);
    }

    protected abstract void generateAndDisplayReport(String var1, String var2);
}

