/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.runner.IExecutor;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerFrontEnd;
import org.eclipse.n4js.tester.ITester;
import org.eclipse.n4js.tester.ProcessTerminationListener;
import org.eclipse.n4js.tester.TestConfiguration;
import org.eclipse.n4js.tester.TestDiscoveryHelper;
import org.eclipse.n4js.tester.TesterEventBus;
import org.eclipse.n4js.tester.TesterFacade;
import org.eclipse.n4js.tester.domain.TestTree;
import org.eclipse.n4js.tester.events.SessionEndedEvent;
import org.eclipse.n4js.tester.extension.ITesterDescriptor;
import org.eclipse.n4js.tester.extension.TesterRegistry;
import org.eclipse.n4js.tester.internal.DefaultTestTreeTransformer;
import org.eclipse.n4js.tester.internal.TesterActivator;

@Singleton
public class TesterFrontEnd {
    private static final int PORT_PLACEHOLDER_MAGIC_NUMBER = 919191919;
    @Inject
    private RunnerFrontEnd runnerFrontEnd;
    @Inject
    private TesterRegistry testerRegistry;
    @Inject
    private TestDiscoveryHelper testDiscoveryHelper;
    @Inject
    private DefaultTestTreeTransformer testTreeTransformer;
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private TesterFacade testerFacade;
    @Inject
    private TesterEventBus eventBus;

    public boolean canTest(URI resourceToTest) {
        return true;
    }

    public TestConfiguration createConfiguration(TestConfiguration configuration) {
        return this.createConfiguration(configuration.getTesterId(), configuration.getImplementationId(), configuration.getUserSelection());
    }

    public TestConfiguration createConfiguration(String testerId, N4JSProjectName implementationId, URI moduleToTest) {
        ITesterDescriptor testerDesc = this.testerRegistry.getDescriptor(testerId);
        ITester tester = testerDesc.getTester();
        TestConfiguration config = tester.createConfiguration();
        config.setName(this.computeConfigurationName(testerId, moduleToTest));
        config.setTesterId(testerId);
        config.setRunnerId(tester.getRunnerIdForTesting());
        config.setRuntimeEnvironment(testerDesc.getEnvironment());
        config.setImplementationId(implementationId);
        config.setUserSelection(moduleToTest);
        this.computeDerivedValues(config);
        return config;
    }

    public TestConfiguration createConfiguration(Map<String, Object> values) {
        String testerId = RunConfiguration.getString(values, (String)"TESTER_ID", (boolean)false);
        ITester tester = this.testerRegistry.getTester(testerId);
        TestConfiguration config = tester.createConfiguration();
        config.writePersistentValues(values);
        List testCaseURIStrings = RunConfiguration.getListOfString(values, (String)"TESTCASE_SELECTION", (boolean)true);
        if (testCaseURIStrings != null && !testCaseURIStrings.isEmpty()) {
            List<URI> uris = testCaseURIStrings.stream().map(s -> URI.createURI((String)s)).collect(Collectors.toList());
            config.setTestMethodSelection(uris);
        }
        this.computeDerivedValues(config);
        return config;
    }

    public void computeDerivedValues(TestConfiguration config) {
        this.runnerFrontEnd.computeDerivedValues((RunConfiguration)config, false);
        List<URI> testMethods = config.getTestMethodSelection();
        if (testMethods.isEmpty()) {
            testMethods = Collections.singletonList(config.getUserSelection());
        }
        TestTree testTree = this.testDiscoveryHelper.collectTests(testMethods);
        config.setTestTree(testTree);
        try {
            TesterActivator testerActivator = TesterActivator.getInstance();
            int port = testerActivator != null ? testerActivator.getServerPort() : 919191919;
            config.setResultReportingPort(port);
            this.testTreeTransformer.setHttpServerPort(Integer.toString(port));
            String testTreeAsJSON = this.objectMapper.writeValueAsString(this.testTreeTransformer.apply(testTree));
            config.setTestTreeAsJSON(testTreeAsJSON);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ITester tester = this.testerRegistry.getTester(config);
        tester.prepareConfiguration(config);
    }

    public Process test(String testerId, N4JSProjectName implementationId, URI resourceToTest) throws ExecutionException {
        return this.test(this.createConfiguration(testerId, implementationId, resourceToTest));
    }

    public Process test(TestConfiguration config) throws ExecutionException {
        return this.test(config, this.runnerFrontEnd.createDefaultExecutor());
    }

    public Process test(TestConfiguration config, IExecutor executor) throws ExecutionException {
        TestTree testTree = config.getTestTree();
        int port = this.testerFacade.prepareTestSession(testTree);
        TesterFrontEnd.updateTestTreeDescription(config, port);
        ITester tester = this.testerRegistry.getTester(config);
        Process process = tester.test(config, executor, this.runnerFrontEnd);
        ProcessTerminationListener.register(process, exitCode -> this.eventBus.post(new SessionEndedEvent(testTree.getSessionId().toString())));
        return process;
    }

    private static void updateTestTreeDescription(TestConfiguration config, int port) {
        if (config.getResultReportingPort() == 919191919) {
            String testTreeJsonEncoded = config.getTestTreeAsJSON();
            String updatedTestTreeJsonEncoded = testTreeJsonEncoded.replaceFirst(Integer.toString(919191919), Integer.toString(port));
            config.setTestTreeAsJSON(updatedTestTreeJsonEncoded);
        }
        config.setResultReportingPort(port);
    }

    private String computeConfigurationName(String testerId, URI moduleToTest) {
        String modulePath = moduleToTest.path();
        modulePath = TesterFrontEnd.stripStart(modulePath, "/", "resource/", "plugin/");
        String moduleName = modulePath.replace('/', '-');
        String runnerName = this.testerRegistry.getDescriptor(testerId).getName();
        return String.valueOf(moduleName) + " (" + runnerName + ")";
    }

    private static final String stripStart(String str, String ... prefixesToStrip) {
        String[] stringArray = prefixesToStrip;
        int n = prefixesToStrip.length;
        int n2 = 0;
        while (n2 < n) {
            String currPrefix = stringArray[n2];
            if (str.startsWith(currPrefix)) {
                str = str.substring(currPrefix.length());
            }
            ++n2;
        }
        return str;
    }
}

