/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.emf;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EObjectFeatureMerger {
    public EObject merge(EObject from, EObject to) {
        EObject copy = EcoreUtil.copy((EObject)from);
        EcoreUtil.resolveAll((EObject)copy);
        return this.merge(copy, to, Sets.newHashSet());
    }

    private EObject merge(EObject from, EObject to, Collection<Object> visitedObjects) {
        if (from == null || to == null) {
            return null;
        }
        if (visitedObjects.contains(from) || visitedObjects.contains(to)) {
            return to;
        }
        visitedObjects.add(to);
        visitedObjects.add(from);
        EList fromFeatures = from.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : fromFeatures) {
            if (-1 == to.eClass().getFeatureID(feature) || !feature.isChangeable() || !from.eIsSet(feature)) continue;
            Object fromValue = from.eGet(feature, true);
            Object toValue = to.eGet(feature, true);
            if (toValue == null) {
                to.eSet(feature, fromValue);
                continue;
            }
            if (feature.isMany()) {
                Collection toManyValue = (Collection)toValue;
                Collection fromManyValue = (Collection)fromValue;
                Iterator itr = fromManyValue.iterator();
                while (itr.hasNext()) {
                    Object fromElement = itr.next();
                    if (this.contains(toManyValue, fromElement)) continue;
                    itr.remove();
                    toManyValue.add(fromElement);
                }
                continue;
            }
            if (feature instanceof EAttribute) {
                to.eSet(feature, fromValue);
                continue;
            }
            if (!(feature instanceof EReference)) continue;
            to.eSet(feature, (Object)this.merge((EObject)fromValue, (EObject)toValue, visitedObjects));
        }
        return to;
    }

    protected boolean contains(Collection<? extends Object> toManyValue, Object fromElement) {
        return toManyValue.contains(fromElement);
    }
}

